/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

public enum JobLevelDefinition {
    LEVEL_9("9", "Founder", "This person is a founder of the organization."),
    LEVEL_8("8", "Executive", "This person is a board member responsible for a significant part of the business - typically involving multiple business areas and services."),
    LEVEL_7("7", "Business Area Manager", "This person manages a business area."),
    LEVEL_6("6", "Senior Manager", "This person manages multiple departments.  They are often responsible for one or more business services within a business area."),
    LEVEL_5("5", "Expert", "This person provides significant expertise that is necessary to run the business.  They may supervise a small number of people but they are not typically personnel managers."),
    LEVEL_4("4", "Personnel Manager", "This person is a manager of supervisors and individual contributors."),
    LEVEL_3("3", "Supervisor", "This person is responsible for supervising a small number of people."),
    LEVEL_2("2", "Individual contributor", "This person is responsible for their own work.");

    public static final String validValueSetName = "JobLevel";
    public static final String validValueSetPropertyName = "jobLevel";
    public static final String validValueSetDescription = "Describes the seniority of an employee in the Coco Pharmaceuticals' organization.";
    public static final String validValueSetUsage = "Stored in the `jobLevel` additional property of the Person entity.";
    public static final String validValueSetScope = "Used when the person described has an employment contract with Coco Pharmaceuticals.";
    public static final JobLevelDefinition defaultValue;
    private final String preferredValue;
    private final String displayName;
    private final String description;

    private JobLevelDefinition(String preferredValue, String displayName, String description) {
        this.preferredValue = preferredValue;
        this.displayName = displayName;
        this.description = description;
    }

    public String getPreferredValue() {
        return this.preferredValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "JobLevelDefinition{" + this.displayName + "}";
    }

    static {
        defaultValue = LEVEL_2;
    }
}

