/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

import org.odpi.openmetadata.samples.archiveutilities.organization.OrganizationTypeDefinition;

public enum OrganizationDefinition {
    COCO("Coco Pharmaceuticals Ltd", "Fictitious mid-sized pharmaceutical company specializing in cancer treatments.", OrganizationTypeDefinition.PRIMARY),
    HAMPTON("Hampton Hospital", "Partner hospital in USA that takes part in clinical trials.", OrganizationTypeDefinition.PARTNER),
    OAK_DENE("Oak Dene Hospital", "Partner hospital in UK that takes part in clinical trials.", OrganizationTypeDefinition.PARTNER),
    OLD_MARKET("Old Market Hospital", "Partner hospital in the Netherlands that takes part in clinical trials.", OrganizationTypeDefinition.PARTNER),
    XDC("XDC", "Partner IT consultancy employed to improve IT systems.", OrganizationTypeDefinition.PARTNER),
    SEC_INC("Sec Inc Consultancy Services", "Partner security consultancy employed to investigate suspected instances of fraud.", OrganizationTypeDefinition.PARTNER),
    SALES_CP("Sales and Marketing Cloud Provider", "Organization providing customer sales and marketing cloud services.", OrganizationTypeDefinition.PARTNER),
    FINANCE_CP("Accounting Services Cloud Provider", "Organization providing accounting software through cloud services.", OrganizationTypeDefinition.PARTNER),
    TRAVEL_CP("TravelPlanner Cloud Provider", "Travel planning, approval, booking and expenses.", OrganizationTypeDefinition.PARTNER);

    public static final String propertyName = "organization";
    private final String displayName;
    private final String description;
    private final OrganizationTypeDefinition organizationType;

    private OrganizationDefinition(String displayName, String description, OrganizationTypeDefinition organizationType) {
        this.displayName = displayName;
        this.description = description;
        this.organizationType = organizationType;
    }

    public String getQualifiedName() {
        return "Organization:" + this.displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public OrganizationTypeDefinition getOrganizationType() {
        return this.organizationType;
    }

    public String toString() {
        return "OrganizationDefinition{" + this.displayName + "}";
    }
}

