/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

public enum OrganizationTypeDefinition {
    PRIMARY("Primary", "Primary Organization", "This is the controlling organization that is the decision maker and owner of the open metadata landscape.", "Use this for coco Pharmaceuticals' Organization entity."),
    PARTNER("Partner", "Partner Organization", "This is for a business partner's Organization entity.", "Use this for partner organizations such as hospitals and suppliers."),
    DEPT("Dept", "Department", "This is for an internal department's Team entity.", "Use this for teams in an organization that are part of the organization structure."),
    COMMUNITY("Community", "Community of Interest", "This is for the Team entity that defines the membership of a self-organizing community of interest.", "Use this for the membership of communities."),
    PROJECT("Project", "Project team", "This is for the Team entity that defines the contributors to a project/campaign.", "Use this for the team assembled to deliver a project.");

    public static final String validValueSetName = "OrganizationType";
    public static final String validValueSetDescription = "Describes the reason behind a team's formation.";
    public static final String validValueSetUsage = "Used in the 'teamType' property of the Team entity.";
    public static final String validValueSetScope = "Used for all types of Teams/Organizations.";
    private final String preferredValue;
    private final String displayName;
    private final String description;
    private final String usage;

    private OrganizationTypeDefinition(String preferredValue, String displayName, String description, String usage) {
        this.preferredValue = preferredValue;
        this.displayName = displayName;
        this.description = description;
        this.usage = usage;
    }

    public String getPreferredValue() {
        return this.preferredValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public String toString() {
        return "OrganizationTypeDefinition{" + this.displayName + "}";
    }
}

