/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.samples.archiveutilities;

import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;

import java.util.Date;

/**
 * CocoArchiveHelper extends the archive helpers provided by core egeria (egeria.git).
 */
public class CocoArchiveHelper extends GovernanceArchiveHelper
{
    /**
     * Constructor passes parameters used to build the open metadata archive's property header.
     * This version is used for multiple dependant archives, and they need to share the guid map.
     *
     * @param archiveBuilder builder where content is cached
     * @param archiveGUID unique identifier for this open metadata archive.
     * @param archiveRootName non-spaced root name of the open metadata archive elements.
     * @param originatorName name of the originator (person or organization) of the archive.
     * @param creationDate data that this archive was created.
     * @param versionNumber version number of the archive.
     * @param versionName version name for the archive.
     * @param guidMapFileName name of the guid map file.
     */
    public CocoArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder,
                             String                     archiveGUID,
                             String                     archiveRootName,
                             String                     originatorName,
                             Date                       creationDate,
                             long                       versionNumber,
                             String                     versionName,
                             String                     guidMapFileName)
    {
        super(archiveBuilder, archiveGUID, archiveRootName, originatorName, creationDate, versionNumber, versionName, guidMapFileName);
    }

}
