/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.businesssystems;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.samples.archiveutilities.EgeriaBaseArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.HostDefinition;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.InformationSupplyChain;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.InformationSupplyChainLink;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.InformationSupplyChainSegment;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.SolutionBlueprint;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.SolutionComponent;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.SolutionComponentActor;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.SolutionComponentWire;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.SolutionRoleDefinition;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.SystemDefinition;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.SystemLevelLineage;
import org.odpi.openmetadata.samples.archiveutilities.governanceengines.CocoGovernanceEnginesArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.organization.CocoOrganizationArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.CocoSustainabilityArchiveWriter;

public class CocoBusinessSystemsArchiveWriter
extends EgeriaBaseArchiveWriter {
    private static final String archiveFileName = "CocoBusinessSystemsArchive.omarchive";
    private static final String archiveGUID = "ac202586-4042-407b-ae51-8096dfda223e";
    private static final String archiveName = "Coco Pharmaceuticals Business Systems";
    private static final String archiveDescription = "The data flows from Coco Pharmaceuticals business systems to the data lake.";
    private static final Date creationDate = new Date(1639984840038L);

    public CocoBusinessSystemsArchiveWriter() {
        super(archiveGUID, archiveName, archiveDescription, creationDate, archiveFileName, new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive(), new CocoOrganizationArchiveWriter().getOpenMetadataArchive(), new CocoSustainabilityArchiveWriter().getOpenMetadataArchive(), new CocoGovernanceEnginesArchiveWriter().getOpenMetadataArchive()});
    }

    public void getArchiveContent() {
        this.addSolutionRoles();
        this.addInformationSupplyChains();
        this.addInformationSupplyChainSegments();
        this.addInformationSupplyChainLinks();
        this.addSolutionBlueprints();
        this.addSolutionComponents();
        this.addSolutionComponentActorDefinitions();
        this.addSolutionComponentWires();
        this.addHosts();
        this.addSystems();
        this.addSystemLineage();
    }

    private void addHosts() {
        for (HostDefinition hostDefinition : HostDefinition.values()) {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(OpenMetadataProperty.OPERATING_SYSTEM.name, hostDefinition.getOperatingSystem());
            additionalProperties.put(OpenMetadataProperty.PATCH_LEVEL.name, hostDefinition.getPatchLevel());
            this.archiveHelper.addAsset(hostDefinition.getHostType().getOpenMetadataTypeName(), hostDefinition.getQualifiedName(), hostDefinition.getHostId(), null, hostDefinition.getDescription(), hostDefinition.getZones(), additionalProperties, null);
            this.archiveHelper.addAssetLocationRelationship(hostDefinition.getHostLocation().getQualifiedName(), hostDefinition.getQualifiedName());
        }
    }

    private void addSystems() {
        for (SystemDefinition systemDefinition : SystemDefinition.values()) {
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, systemDefinition.getSystemType().getPreferredValue());
            extendedProperties.put(OpenMetadataProperty.USER_ID.name, systemDefinition.getUserId());
            this.archiveHelper.setGUID(systemDefinition.getQualifiedName(), systemDefinition.getSystemGUID());
            String serverGUID = this.archiveHelper.addAsset(OpenMetadataType.SOFTWARE_SERVER.typeName, systemDefinition.getQualifiedName(), systemDefinition.getSystemId(), systemDefinition.getVersionIdentifier(), systemDefinition.getDescription(), systemDefinition.getZones(), null, extendedProperties);
            assert (serverGUID.equals(systemDefinition.getSystemGUID()));
            if (systemDefinition.getSystemType().getServerPurpose() != null) {
                this.archiveHelper.addServerPurposeClassification(serverGUID, systemDefinition.getSystemType().getServerPurpose(), null);
            }
            if (systemDefinition.getSystemType().getSoftwareServerCapabilities() != null) {
                for (String string : systemDefinition.getSystemType().getSoftwareServerCapabilities()) {
                    String softwareCapabilityQName = string + " for " + systemDefinition.getQualifiedName();
                    if (string.endsWith(OpenMetadataType.ENGINE.typeName)) {
                        Classification engineClassification = this.archiveHelper.getEngineClassification(string);
                        this.archiveHelper.addSoftwareCapability(OpenMetadataType.ENGINE.typeName, softwareCapabilityQName, softwareCapabilityQName, null, null, null, null, null, null, null, engineClassification, serverGUID, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.ASSET.typeName, null);
                    } else {
                        this.archiveHelper.addSoftwareCapability(string, softwareCapabilityQName, softwareCapabilityQName, null, null, null, null, null, null, null, (Classification)null, serverGUID, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.ASSET.typeName, null);
                    }
                    this.archiveHelper.addSupportedSoftwareCapabilityRelationship(softwareCapabilityQName, systemDefinition.getQualifiedName(), null, null, null, null, 1);
                }
            }
            if (systemDefinition.getSystemLocation() != null) {
                this.archiveHelper.addAssetLocationRelationship(systemDefinition.getSystemLocation().getQualifiedName(), systemDefinition.getQualifiedName());
            }
            if (systemDefinition.getDeployedOn() != null) {
                for (HostDefinition hostDefinition : systemDefinition.getDeployedOn()) {
                    this.archiveHelper.addDeployedOnRelationship(systemDefinition.getQualifiedName(), hostDefinition.getQualifiedName(), null, null, null, null, 1);
                }
            }
            if (systemDefinition.getImplementingComponents() == null) continue;
            for (SolutionComponent solutionComponent : systemDefinition.getImplementingComponents()) {
                this.archiveHelper.addImplementedByRelationship(solutionComponent.getGUID(), systemDefinition.getSystemGUID(), "archaeological mapping", "supports required capability", null, null);
            }
        }
    }

    private void addSystemLineage() {
        for (SystemLevelLineage systemLevelLineage : SystemLevelLineage.values()) {
            this.archiveHelper.addLineageRelationship(systemLevelLineage.getSourceSystem().getSystemGUID(), systemLevelLineage.getDestinationSystem().getSystemGUID(), systemLevelLineage.getRelationshipName(), systemLevelLineage.getRelationshipLabel(), systemLevelLineage.getISCQualifiedName());
        }
    }

    private void addSolutionRoles() {
        for (SolutionRoleDefinition solutionRoleDefinition : SolutionRoleDefinition.values()) {
            this.archiveHelper.setGUID(solutionRoleDefinition.getQualifiedName(), solutionRoleDefinition.getGUID());
            String solutionRoleGUID = this.archiveHelper.addActorRole(OpenMetadataType.SOLUTION_ACTOR_ROLE.typeName, solutionRoleDefinition.getQualifiedName(), solutionRoleDefinition.getIdentifier(), solutionRoleDefinition.getDisplayName(), solutionRoleDefinition.getDescription(), solutionRoleDefinition.getScope().getPreferredValue(), false, 0, null, null);
            assert (solutionRoleGUID.equals(solutionRoleDefinition.getGUID()));
        }
    }

    private void addInformationSupplyChains() {
        String methodName = "addInformationSupplyChains";
        for (InformationSupplyChain informationSupplyChain : InformationSupplyChain.values()) {
            this.archiveHelper.setGUID(informationSupplyChain.getQualifiedName(), informationSupplyChain.getGUID());
            String iscGUID = this.archiveHelper.addInformationSupplyChain(OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName, informationSupplyChain.getQualifiedName(), informationSupplyChain.getDisplayName(), informationSupplyChain.getDescription(), informationSupplyChain.getScope().getPreferredValue(), informationSupplyChain.getPurposes(), null, null);
            assert (iscGUID.equals(informationSupplyChain.getGUID()));
            if (!informationSupplyChain.isTemplate()) continue;
            this.archiveHelper.addTemplateClassification(iscGUID, informationSupplyChain.getTemplateName(), informationSupplyChain.getTemplateDescription(), "V1.0", null, "addInformationSupplyChains");
        }
    }

    private void addInformationSupplyChainSegments() {
        for (InformationSupplyChainSegment segment : InformationSupplyChainSegment.values()) {
            this.archiveHelper.setGUID(segment.getQualifiedName(), segment.getGUID());
            String segmentGUID = this.archiveHelper.addInformationSupplyChainSegment(segment.getOwningSupplyChain().getGUID(), OpenMetadataType.INFORMATION_SUPPLY_CHAIN_SEGMENT.typeName, segment.getQualifiedName(), segment.getDisplayName(), segment.getDescription(), segment.getScope().getPreferredValue(), segment.getIntegrationStyle(), null, segment.getOwner(), segment.getOwnerTypeName(), segment.getOwnerPropertyName(), null, null);
            assert (segmentGUID.equals(segment.getGUID()));
        }
    }

    private void addInformationSupplyChainLinks() {
        for (InformationSupplyChainLink informationSupplyChainLink : InformationSupplyChainLink.values()) {
            this.archiveHelper.addInformationSupplyChainLinkRelationship(informationSupplyChainLink.getSegment1().getGUID(), informationSupplyChainLink.getSegment2().getGUID(), informationSupplyChainLink.getLabel(), informationSupplyChainLink.getDescription());
        }
    }

    private void addSolutionComponentWires() {
        for (SolutionComponentWire solutionComponentWire : SolutionComponentWire.values()) {
            this.archiveHelper.addSolutionLinkingWireRelationship(solutionComponentWire.getComponent1().getGUID(), solutionComponentWire.getComponent2().getGUID(), solutionComponentWire.getLabel(), solutionComponentWire.getDescription(), solutionComponentWire.getInformationSupplySegmentGUIDs());
        }
    }

    private void addSolutionBlueprints() {
        String methodName = "addSolutionBlueprints";
        for (SolutionBlueprint solutionBlueprint : SolutionBlueprint.values()) {
            this.archiveHelper.setGUID(solutionBlueprint.getQualifiedName(), solutionBlueprint.getGUID());
            String blueprintGUID = this.archiveHelper.addSolutionBlueprint(OpenMetadataType.SOLUTION_BLUEPRINT.typeName, solutionBlueprint.getQualifiedName(), solutionBlueprint.getDisplayName(), solutionBlueprint.getDescription(), solutionBlueprint.getVersionIdentifier(), null, null);
            assert (blueprintGUID.equals(solutionBlueprint.getGUID()));
            if (!solutionBlueprint.isTemplate()) continue;
            this.archiveHelper.addTemplateClassification(blueprintGUID, "Standard Solution Blueprint Template", null, "V1.0", null, "addSolutionBlueprints");
        }
    }

    private void addSolutionComponents() {
        for (SolutionComponent solutionComponent : SolutionComponent.values()) {
            this.archiveHelper.setGUID(solutionComponent.getQualifiedName(), solutionComponent.getGUID());
            List<SolutionBlueprint> consumingSolutionBlueprints = solutionComponent.getConsumingBlueprints();
            ArrayList<String> consumingSolutionBlueprintGUIDs = null;
            if (consumingSolutionBlueprints != null) {
                consumingSolutionBlueprintGUIDs = new ArrayList<String>();
                for (SolutionBlueprint solutionBlueprint : consumingSolutionBlueprints) {
                    if (solutionBlueprint == null) continue;
                    consumingSolutionBlueprintGUIDs.add(solutionBlueprint.getGUID());
                }
            }
            String componentGUID = this.archiveHelper.addSolutionComponent(consumingSolutionBlueprintGUIDs, OpenMetadataType.SOLUTION_COMPONENT.typeName, solutionComponent.getQualifiedName(), solutionComponent.getDisplayName(), solutionComponent.getDescription(), solutionComponent.getVersionIdentifier(), solutionComponent.getComponentType(), solutionComponent.getImplementationType(), null, null, null, null);
            assert (componentGUID.equals(solutionComponent.getGUID()));
            if (solutionComponent.getSubComponents() != null) {
                for (SolutionComponent subComponent : solutionComponent.getSubComponents()) {
                    this.archiveHelper.addSolutionCompositionRelationship(componentGUID, subComponent.getGUID());
                }
            }
            if (solutionComponent.getLinkedFromSegment() != null) {
                for (InformationSupplyChainSegment segment : solutionComponent.getLinkedFromSegment()) {
                    this.archiveHelper.addImplementedByRelationship(segment.getGUID(), solutionComponent.getGUID(), "Information Supply Chain Refinement", "Supporting Supply Chain", null, null);
                }
            }
            if (solutionComponent.getImplementedBy() == null) continue;
            this.archiveHelper.addImplementedByRelationship(solutionComponent.getGUID(), solutionComponent.getImplementedBy(), "Standard implementation", "Runnable component", null, null);
        }
    }

    private void addSolutionComponentActorDefinitions() {
        for (SolutionComponentActor solutionRoleDefinition : SolutionComponentActor.values()) {
            this.archiveHelper.addSolutionComponentActorRelationship(solutionRoleDefinition.getSolutionRole().getGUID(), solutionRoleDefinition.getSolutionComponent().getGUID(), solutionRoleDefinition.getRole(), solutionRoleDefinition.getDescription());
        }
    }
}

