/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.businesssystems;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.HostTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.FacilityDefinition;

public enum HostDefinition {
    COCO_MFG_PLANNING_AMS_HOST("ams03", "Amsterdam data centre standard machine 03.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AMSTERDAM_DC, "https://ams03.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    COCO_PROCUREMENT_AMS_HOST("ams45", "Amsterdam data centre standard machine 45.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AMSTERDAM_DC, "https://ams45.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    COCO_PROCUREMENT_NY_HOST("327-3", "NY data center standard machine 327-3.", HostTypeDefinition.BARE_METAL, FacilityDefinition.NEW_YORK_DC, "https://ny327-3.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    COCO_PROCUREMENT_WINCH_HOST("winch12", "Winchester data centre standard machine 12.", HostTypeDefinition.BARE_METAL, FacilityDefinition.WINCHESTER_DC, "https://winch12.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 34L),
    DEPOT_MANAGEMENT_WINCH_HOST("winch17", "Winchester data centre standard machine 17.", HostTypeDefinition.BARE_METAL, FacilityDefinition.WINCHESTER_DC, "https://winch17.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 500L),
    DEPOT_MANAGEMENT_KC_HOST("kcdepot", "Kansas City data centre standard machine 01.", HostTypeDefinition.BARE_METAL, FacilityDefinition.WINCHESTER_DC, "https://kc01.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 510L),
    COCO_PROCUREMENT_AUS_HOST("capital", "Austin data centre standard machine capital.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AUSTIN_DC, "https://capital.aus.coco.com", "Linux", "21.1", null, new String[]{"machines"}, 1001L),
    COCO_PROCUREMENT_ED_HOST("ed01", "Edmonton data centre standard machine 01.", HostTypeDefinition.BARE_METAL, FacilityDefinition.EDMONTON_OFFICE, "https://ed01.coco.com", "Ubuntu", "22.04", null, new String[]{"machines"}, 1501L),
    DEPOT_MANAGEMENT_ED_HOST("ed02", "Edmonton data centre standard machine 02.", HostTypeDefinition.BARE_METAL, FacilityDefinition.EDMONTON_OFFICE, "https://ed02.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 520L),
    COCO_INVENTORY_HOST("ams23", "Amsterdam data centre standard machine 23.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AMSTERDAM_DC, "https://ams23.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    COCO_SUS_AMS_HOST("ams04", "Amsterdam data centre standard machine 04.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AMSTERDAM_DC, "https://ams04.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 500L),
    COCO_HRIM_HOST("ams02", "Amsterdam data centre standard machine 02.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AMSTERDAM_DC, "https://ams02.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    COCO_PAGES_HOST("ams06", "Amsterdam data centre standard machine 06.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AMSTERDAM_DC, "https://ams06.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    SEC_ADMIN_HOST("ams01", "Amsterdam data centre standard machine 01.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AMSTERDAM_DC, "https://ams01.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    UK_PAYROLL_HOST("lon02", "London data centre standard machine 02.", HostTypeDefinition.BARE_METAL, FacilityDefinition.LONDON_DC, "https://lon02.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    NL_PAYROLL_HOST("ams56", "Amsterdam data centre standard machine 56.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AMSTERDAM_DC, "https://ams56.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    CA_PAYROLL_HOST("ed05", "Edmonton data centre standard machine 05.", HostTypeDefinition.BARE_METAL, FacilityDefinition.EDMONTON_OFFICE, "https://ed05.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 0L),
    AUS_MANUFACTURING_CONTROL_HOST("mopac", "Austin data center standard machine mopac.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AUSTIN_DC, "https://mopac.aus.coc.com", "Linux", "21.1", null, new String[]{"machines"}, 1900L),
    AUS_OMAG_EDGE_03("longhorn", "Austin data centre standard machine for metadata host Edge03.", HostTypeDefinition.BARE_METAL, FacilityDefinition.WINCHESTER_DC, "https://winch06.coco.com", "Ubuntu", "22.04", null, new String[]{"machines"}, 2000L),
    WINCH_MANUFACTURING_CONTROL_HOST("winch01", "Winchester data centre standard machine 01.", HostTypeDefinition.BARE_METAL, FacilityDefinition.WINCHESTER_DC, "https://winch01.coco.com", "Ubuntu", "22.04", null, new String[]{"machines"}, 1000L),
    WINCH_OMAG_EDGE_01("winch06", "Winchester data centre metadata host machine 06.", HostTypeDefinition.BARE_METAL, FacilityDefinition.WINCHESTER_DC, "https://winch06.coco.com", "Ubuntu", "22.04", null, new String[]{"machines"}, 2000L),
    ED_MANUFACTURING_CONTROL_HOST("ed04", "Edmonton data centre standard machine 04.", HostTypeDefinition.BARE_METAL, FacilityDefinition.EDMONTON_OFFICE, "https://ed04.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 1000L),
    ED_OMAG_EDGE_02("ed013", "Edmonton data centre metadata host machine 13.", HostTypeDefinition.BARE_METAL, FacilityDefinition.EDMONTON_OFFICE, "https://ed013.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 2005L),
    HAZ_MAT_HOST("ams14", "Amsterdam data centre standard machine ams14.", HostTypeDefinition.BARE_METAL, FacilityDefinition.AMSTERDAM_DC, "https://ams14.coco.com", "Ubuntu", "23.04", null, new String[]{"machines"}, 1000L);

    private final String hostId;
    private final String description;
    private final HostTypeDefinition hostType;
    private final FacilityDefinition hostLocation;
    private final String networkAddress;
    private final String operatingSystem;
    private final String patchLevel;
    private final HostDefinition deployedOn;
    private final String[] zones;
    private final long loadTime;

    private HostDefinition(String hostId, String description, HostTypeDefinition hostType, FacilityDefinition hostLocation, String networkAddress, String operatingSystem, String patchLevel, HostDefinition deployedOn, String[] zones, long loadTime) {
        this.hostId = hostId;
        this.description = description;
        this.hostType = hostType;
        this.hostLocation = hostLocation;
        this.networkAddress = networkAddress;
        this.operatingSystem = operatingSystem;
        this.patchLevel = patchLevel;
        this.deployedOn = deployedOn;
        this.zones = zones;
        this.loadTime = loadTime;
    }

    public String getQualifiedName() {
        return "Host::" + this.getHostType().getOpenMetadataTypeName() + "::" + this.hostId;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getZones() {
        if (this.zones != null) {
            return Arrays.asList(this.zones);
        }
        return null;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public HostTypeDefinition getHostType() {
        return this.hostType;
    }

    public FacilityDefinition getHostLocation() {
        return this.hostLocation;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getPatchLevel() {
        return this.patchLevel;
    }

    public HostDefinition getDeployedOn() {
        return this.deployedOn;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public String toString() {
        return "HostDefinition{" + this.hostId + "}";
    }
}

