/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.clinicaltrialtemplates;

import org.odpi.openmetadata.samples.archiveutilities.clinicaltrialtemplates.GlossaryCategoryDefinition;

public enum GlossaryTermDefinition {
    PATIENT_IDENTIFIER("Patient Identifier", "Unique identifier of patient.", "Unique identifier for the individual that has agree to take part in this study.  The identifier on its own is anonymous, preserving the privacy of the patient.  However, there is a database that ties the patient identifier to the name of the bear.", "PatientId", "Acts as an anonymous identifier for a patient in a clinical trial.", GlossaryCategoryDefinition.GENERIC_DATA_FIELDS),
    DATE_OF_BIRTH("Patient Date of Birth", "Day, month and year that the patient was born.", "This is the day that the person was born.  Not official birth date if different.", "PatientDateOfBirth", "Acts as a standard mechanism for measuring the age of a patient in a clinical trial.", GlossaryCategoryDefinition.GENERIC_DATA_FIELDS),
    HEIGHT("Patient Height", "Height of patient in centimetres.", "This is the height of the patient in centimetres, without shoes and to the top of the skull, ideally measured in the morning.", "PatientHeight", "Acts as a standard mechanism for measuring the height of a patient in a clinical trial.", GlossaryCategoryDefinition.GENERIC_DATA_FIELDS),
    WEIGHT("Patient Weight", "Weight of patient in kilograms.", "This is the weight of the patient in kilograms to 1 decimal place, without outer clothes on, ideally measured in the morning.", "PatientWeight", "Acts as a standard mechanism for measuring the weight of a patient in a clinical trial.", GlossaryCategoryDefinition.GENERIC_DATA_FIELDS),
    BLOOD_PRESSURE("Patient Blood Pressure", "Blood pressure of patient (systolic and diastolic).", "Blood pressure is the pressure of circulating blood against the walls of blood vessels. Most of this pressure results from the heart pumping blood through the circulatory system. Blood pressure is expressed in terms of the systolic pressure over diastolic pressure in the cardiac cycle. It is measured in millimetres of mercury above the surrounding atmospheric pressure, or in kilopascals. The difference between the systolic and diastolic pressures is known as pulse pressure, while the average pressure during a cardiac cycle is known as mean arterial pressure.", "PatientBloodPressure", "Acts as one of the standard mechanism for measuring the health of a patient in a clinical trial.", GlossaryCategoryDefinition.GENERIC_DATA_FIELDS),
    MEASUREMENT_DATE("Measurement Date", "The date that the patient measurement was made.", "The measurements are from a discrete day so that any changes in a patient's condition can be measured.  The format of the date may vary depending on the source of the measurement.", "MeasurementDate", "Used to identify the data of any patient measurement during a clinical trial.", GlossaryCategoryDefinition.GENERIC_DATA_FIELDS),
    ANGLE_LEFT("Left Hip Rotation Angle", "The number of degrees of rotation of the left foot measured from vertical.", "As the stuffing around the hip weakens, the foot on the attached leg rotates, typically outwards when the teddy bear is sitting.  This measurement is an integer measuring the number of degrees of rotation of the left foot measured from vertical. Positive values measure that the foot is rotating outwards.", "AngleLeft", "Definition for use in the Teddy Bear Drop Foot demonstration study.", GlossaryCategoryDefinition.TBDF_DATA_FIELDS),
    ANGLE_RIGHT("Right Hip Rotation Angle", "The number of degrees of rotation of the right foot measured from vertical.", "As the stuffing around the hip weakens, the foot on the attached leg rotates, typically outwards when the teddy bear is sitting.  This measurement is an integer measuring the number of degrees of rotation of the right foot measured from vertical. Positive values measure that the foot is rotating outwards.", "AngleRight", "Definition for use in the Teddy Bear Drop Foot demonstration study.", GlossaryCategoryDefinition.TBDF_DATA_FIELDS);

    private final String name;
    private final String summary;
    private final String description;
    private final String abbreviation;
    private final String usage;
    private final GlossaryCategoryDefinition category;

    private GlossaryTermDefinition(String name, String summary, String description, String abbreviation, String usage, GlossaryCategoryDefinition category) {
        this.name = name;
        this.summary = summary;
        this.description = description;
        this.abbreviation = abbreviation;
        this.usage = usage;
        this.category = category;
    }

    public String getQualifiedName() {
        return "GlossaryTerm::ClinicalTrialTerminology::" + this.abbreviation;
    }

    public String getTemplateSubstituteQualifiedName() {
        return "GlossaryTerm::ClinicalTrialTerminology::TemplateSubstitute::" + this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String getTemplateSubstituteName() {
        return this.name;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTemplateSubstituteSummary() {
        return "Template Substitute for " + this.name;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getTemplateSubstituteUsage() {
        return "Only for use in templates.";
    }

    public String getDescription() {
        return this.description;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public GlossaryCategoryDefinition getCategory() {
        return this.category;
    }

    public GlossaryCategoryDefinition getSubstituteCategory() {
        return GlossaryCategoryDefinition.TEMPLATE_SUBSTITUTES;
    }

    public String toString() {
        return "GlossaryTermDefinition{" + this.summary + "}";
    }
}

