/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceengines;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.OriginSeekerGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.OriginSeekerGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.RetentionClassifierGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.ZonePublisherGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.EvaluateAnnotationsGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericFolderWatchdogGovernanceActionProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.RequestTypeDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyActionGuard;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.samples.archiveutilities.EgeriaBaseArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.GovernanceActionDescription;
import org.odpi.openmetadata.samples.archiveutilities.governanceengines.CocoGovernanceEngineDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceengines.CocoGovernanceServiceDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceengines.CocoRequestTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CocoGovernanceProgramArchiveWriter;

public class CocoGovernanceEnginesArchiveWriter
extends EgeriaBaseArchiveWriter {
    private static final String archiveFileName = "CocoGovernanceEngineDefinitionsArchive.omarchive";
    private static final String archiveGUID = "9cbd2b33-e80f-4df2-adc6-d859ebff4c34";
    private static final String archiveName = "CocoGovernanceEngineDefinitions";
    private static final String archiveDescription = "Governance Engines for Coco Pharmaceuticals.";
    private static final Date creationDate = new Date(1639984840038L);

    public CocoGovernanceEnginesArchiveWriter() {
        super(archiveGUID, archiveName, archiveDescription, creationDate, archiveFileName, new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive(), new CocoGovernanceProgramArchiveWriter().getOpenMetadataArchive()});
    }

    private String getAssetGovernanceEngine() {
        String assetGovernanceEngineName = "AssetGovernance@CocoPharmaceuticals";
        String assetGovernanceEngineDisplayName = "Asset Governance Governance Action Engine";
        String assetGovernanceEngineDescription = "Monitors, validates and enriches metadata relating to assets.";
        String assetGovernanceEngineUserId = "assetgovernancenpa";
        return this.archiveHelper.addGovernanceEngine(OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "AssetGovernance@CocoPharmaceuticals", "Asset Governance Governance Action Engine", "Monitors, validates and enriches metadata relating to assets.", null, null, null, null, "assetgovernancenpa", null, null);
    }

    private String getAssetDiscoveryEngine() {
        String assetDiscoveryEngineName = "AssetDiscovery@CocoPharmaceuticals";
        String assetDiscoveryEngineDisplayName = "Asset Discovery Survey Action Engine";
        String assetDiscoveryEngineDescription = "Extracts metadata about a digital resource and attach it to its asset description.";
        String assetDiscoveryEngineUserId = "assetdiscoverynpa";
        return this.archiveHelper.addGovernanceEngine(OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "AssetDiscovery@CocoPharmaceuticals", "Asset Discovery Survey Action Engine", "Extracts metadata about a digital resource and attach it to its asset description.", null, null, null, null, "assetdiscoverynpa", null, null);
    }

    private void addRequestType(String governanceEngineGUID, String governanceEngineName, String governanceEngineTypeName, String governanceRequestType, String serviceRequestType, Map<String, String> requestParameters, List<NewActionTarget> actionTargets, GovernanceActionDescription governanceActionDescription, String governanceActionTypeGUID, String supportedElementQualifiedName) {
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, governanceRequestType, serviceRequestType, requestParameters, governanceActionDescription.governanceServiceGUID);
        String governanceActionTypeQualifiedName = governanceEngineName + "::" + governanceRequestType;
        this.archiveHelper.setGUID(governanceActionTypeQualifiedName, governanceActionTypeGUID);
        String guid = this.archiveHelper.addGovernanceActionType(null, governanceEngineGUID, governanceEngineTypeName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, null, governanceActionTypeQualifiedName, governanceRequestType + " (" + governanceEngineName + ")", governanceActionDescription.governanceServiceDescription, 0, governanceActionDescription.supportedRequestParameters, governanceActionDescription.supportedActionTargets, governanceActionDescription.supportedAnalysisSteps, governanceActionDescription.supportedAnnotationTypes, governanceActionDescription.producedRequestParameters, governanceActionDescription.producedActionTargets, governanceActionDescription.producedGuards, 0, null, null, null);
        assert (governanceActionTypeGUID.equals(guid));
        this.archiveHelper.addGovernanceActionExecutor(governanceActionTypeGUID, governanceRequestType, requestParameters, null, null, null, null, governanceEngineGUID);
        if (actionTargets != null) {
            for (NewActionTarget actionTarget : actionTargets) {
                if (actionTarget == null) continue;
                this.archiveHelper.addTargetForActionType(governanceActionTypeGUID, actionTarget);
            }
        }
        if (supportedElementQualifiedName != null) {
            String supportedElementGUID = this.archiveHelper.queryGUID(supportedElementQualifiedName);
            this.archiveHelper.addResourceListRelationshipByGUID(supportedElementGUID, governanceActionTypeGUID, governanceActionDescription.resourceUse.getResourceUse(), governanceActionDescription.governanceServiceDescription, requestParameters, false);
        }
    }

    private String getFileProvisioningGovernanceActionService() {
        String governanceServiceName = "coco-file-provisioning-governance-action-service";
        String governanceServiceDisplayName = "File {move, copy, delete} Governance Action Service";
        String governanceServiceDescription = "Works with files.  The request type defines which action is taken.  The request parameters define the source file and destination, along with lineage options";
        String ftpGovernanceServiceProviderClassName = MoveCopyFileGovernanceActionProvider.class.getName();
        return this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getDeployedImplementationType(), ftpGovernanceServiceProviderClassName, null, "coco-file-provisioning-governance-action-service", "File {move, copy, delete} Governance Action Service", "Works with files.  The request type defines which action is taken.  The request parameters define the source file and destination, along with lineage options", null);
    }

    private String getWatchdogGovernanceActionService() {
        String governanceServiceName = "coco-new-measurements-watchdog-governance-action-service";
        String governanceServiceDisplayName = "New Measurements Watchdog Governance Action Service";
        String governanceServiceDescription = "Initiates a governance action process when a new weekly measurements file arrives.";
        String governanceServiceProviderClassName = GenericFolderWatchdogGovernanceActionProvider.class.getName();
        return this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getDeployedImplementationType(), governanceServiceProviderClassName, null, "coco-new-measurements-watchdog-governance-action-service", "New Measurements Watchdog Governance Action Service", "Initiates a governance action process when a new weekly measurements file arrives.", null);
    }

    private String getZonePublisherGovernanceActionService() {
        String governanceServiceName = "coco-zone-publisher-governance-action-service";
        String governanceServiceDisplayName = "Update Asset's Zone Membership Governance Action Service";
        String governanceServiceDescription = "Set up the zone membership for one or more assets supplied as action targets.";
        String governanceServiceProviderClassName = ZonePublisherGovernanceActionProvider.class.getName();
        return this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getDeployedImplementationType(), governanceServiceProviderClassName, null, "coco-zone-publisher-governance-action-service", "Update Asset's Zone Membership Governance Action Service", "Set up the zone membership for one or more assets supplied as action targets.", null);
    }

    private String getOriginSeekerGovernanceActionService() {
        String governanceServiceName = "coco-origin-seeker-governance-action-service";
        String governanceServiceDisplayName = "Locate and Set Origin Governance Action Service";
        String governanceServiceDescription = "Navigates back through the lineage relationships to locate the origin classification(s) from the source(s) and sets it on the requested asset if the origin is unique.";
        String governanceServiceProviderClassName = OriginSeekerGovernanceActionProvider.class.getName();
        return this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getDeployedImplementationType(), governanceServiceProviderClassName, null, "coco-origin-seeker-governance-action-service", "Locate and Set Origin Governance Action Service", "Navigates back through the lineage relationships to locate the origin classification(s) from the source(s) and sets it on the requested asset if the origin is unique.", null);
    }

    private void addFTPFileRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "simulate-ftp";
        String serviceRequestType = "copy-file";
        String noLineagePropertyName = "noLineage";
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("noLineage", "");
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "simulate-ftp", "copy-file", requestParameters, governanceServiceGUID);
    }

    private void addWatchNestedInFolderRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "watch-for-new-files";
        String serviceRequestType = "watch-nested-in-folder";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "watch-for-new-files", "watch-nested-in-folder", null, governanceServiceGUID);
    }

    private void addCopyFileRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "copy-file";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "copy-file", null, null, governanceServiceGUID);
    }

    private void addMoveFileRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "move-file";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "move-file", null, null, governanceServiceGUID);
    }

    private void addDeleteFileRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "delete-file";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "delete-file", null, null, governanceServiceGUID);
    }

    private void addSeekOriginRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceServiceRequestType = "seek-origin";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "seek-origin", null, null, governanceServiceGUID);
    }

    private void addSetZoneMembershipRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceServiceRequestType = "set-zone-membership";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "set-zone-membership", null, null, governanceServiceGUID);
    }

    public void getArchiveContent() {
        for (CocoGovernanceEngineDefinition cocoGovernanceEngineDefinition : CocoGovernanceEngineDefinition.values()) {
            this.createGovernanceEngine(cocoGovernanceEngineDefinition);
        }
        for (Enum enum_ : CocoGovernanceServiceDefinition.values()) {
            this.addGovernanceServiceDefinition((CocoGovernanceServiceDefinition)enum_);
        }
        for (Enum enum_ : CocoRequestTypeDefinition.values()) {
            this.addRequestType(((CocoRequestTypeDefinition)enum_).getGovernanceEngine().getGUID(), ((CocoRequestTypeDefinition)enum_).getGovernanceEngine().getName(), ((CocoRequestTypeDefinition)enum_).getGovernanceEngine().getType(), ((CocoRequestTypeDefinition)enum_).getGovernanceRequestType(), ((CocoRequestTypeDefinition)enum_).getServiceRequestType(), ((CocoRequestTypeDefinition)enum_).getRequestParameters(), ((CocoRequestTypeDefinition)enum_).getActionTargets(), ((CocoRequestTypeDefinition)enum_).getGovernanceService().getGovernanceActionDescription(), ((CocoRequestTypeDefinition)enum_).getGovernanceActionTypeGUID(), ((CocoRequestTypeDefinition)enum_).getSupportedElementQualifiedName());
        }
        this.addOnboardingGovernanceActionProcess();
    }

    private void createGovernanceEngine(CocoGovernanceEngineDefinition governanceEngineDefinition) {
        this.archiveHelper.setGUID(governanceEngineDefinition.getName(), governanceEngineDefinition.getGUID());
        this.archiveHelper.addGovernanceEngine(governanceEngineDefinition.getType(), governanceEngineDefinition.getName(), governanceEngineDefinition.getDisplayName(), governanceEngineDefinition.getDescription(), null, null, null, null, governanceEngineDefinition.getUserId(), null, null);
    }

    private void addGovernanceServiceDefinition(CocoGovernanceServiceDefinition governanceServiceDefinition) {
        this.archiveHelper.setGUID(governanceServiceDefinition.getName(), governanceServiceDefinition.getGUID());
        this.archiveHelper.addGovernanceService(governanceServiceDefinition.getDeployedImplementationType().getAssociatedTypeName(), governanceServiceDefinition.getDeployedImplementationType().getDeployedImplementationType(), governanceServiceDefinition.getConnectorProviderClassName(), null, governanceServiceDefinition.getName(), governanceServiceDefinition.getDisplayName(), governanceServiceDefinition.getDescription(), null);
    }

    private void addOnboardingGovernanceActionProcess() {
        String step6GUID;
        String step5GUID;
        String step4GUID;
        String step3GUID;
        String step2GUID;
        String qualifiedName = "Coco:GovernanceActionProcess:ClinicalTrials:WeeklyMeasurements:Onboarding";
        String processGUID = this.archiveHelper.addGovernanceActionProcess(OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, qualifiedName, "Onboard Landing Area Files For Clinical Trial Project", "V1.0", "Ensures that new files added to the landing are correctly catalogued in the data lake.\n\nThis process performs the follow function:\n     1) The physical file is moved to the data lake and renamed,\n     2) A new asset is created for the new file,\n     3) Lineage is created between the original file asset and the new file asset,\n     4) The owner and origin are assigned,\n     5) The governance zones are assigned to make the new asset visible to the research team.", null, 0, null, null, null);
        String step1GUID = this.archiveHelper.addGovernanceActionProcessStep(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, processGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, OpenMetadataType.ASSET.typeName, null, qualifiedName + ":MoveWeeklyMeasurementsFile", "Move Weekly Measurements File", "The physical file is moved to the data lake and renamed, an asset is created for the new file (in the quarantine zone) and a lineage relationship is created between the original file asset and the new file asset.", 0, null, null, null, null, null, null, null, 0, true, null, null, null);
        if (step1GUID != null) {
            this.archiveHelper.addGovernanceActionExecutor(step1GUID, RequestTypeDefinition.MOVE_FILE.getGovernanceRequestType(), null, null, null, null, null, RequestTypeDefinition.MOVE_FILE.getGovernanceEngine().getGUID());
            this.archiveHelper.addGovernanceActionProcessFlow(processGUID, null, null, step1GUID);
        }
        if ((step2GUID = this.archiveHelper.addGovernanceActionProcessStep(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, processGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, OpenMetadataType.ASSET.typeName, null, qualifiedName + ":SeekOrigin", "Seek and validate origin", "Validate that origin of the file is correctly set up.", 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            this.archiveHelper.addGovernanceActionExecutor(step2GUID, RequestTypeDefinition.SEEK_ORIGIN.getGovernanceRequestType(), null, null, null, null, null, RequestTypeDefinition.SEEK_ORIGIN.getGovernanceEngine().getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, MoveCopyFileGuard.PROVISIONING_COMPLETE.getName(), false, step2GUID);
        }
        if ((step3GUID = this.archiveHelper.addGovernanceActionProcessStep(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, processGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, OpenMetadataType.ASSET.typeName, null, qualifiedName + ":SetRetentionPeriod", "Set retention period", "Set up the dates when the data associated with the asset should be archived and then deleted.", 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            this.archiveHelper.addGovernanceActionExecutor(step3GUID, RequestTypeDefinition.RETENTION_PERIOD.getGovernanceRequestType(), null, null, null, null, null, RequestTypeDefinition.RETENTION_PERIOD.getGovernanceEngine().getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step2GUID, OriginSeekerGuard.ORIGIN_ASSIGNED.getName(), false, step3GUID);
            this.archiveHelper.addNextGovernanceActionProcessStep(step2GUID, OriginSeekerGuard.ORIGIN_ALREADY_ASSIGNED.getName(), false, step3GUID);
        }
        if ((step4GUID = this.archiveHelper.addGovernanceActionProcessStep(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, processGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, OpenMetadataType.ASSET.typeName, null, qualifiedName + ":DataQuality", "Check quality of data", "Validate that origin of the file is correctly set up.", 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            this.archiveHelper.addGovernanceActionExecutor(step4GUID, CocoRequestTypeDefinition.CHECK_DATA.getGovernanceRequestType(), null, null, null, null, null, CocoRequestTypeDefinition.CHECK_DATA.getGovernanceEngine().getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, MoveCopyFileGuard.PROVISIONING_COMPLETE.getName(), false, step4GUID);
        }
        if ((step5GUID = this.archiveHelper.addGovernanceActionProcessStep(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, processGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, OpenMetadataType.ASSET.typeName, null, qualifiedName + ":CheckForRFAs", "Check for quality issues", "Validate that there are no reported data qualify issues.", 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            this.archiveHelper.addGovernanceActionExecutor(step5GUID, RequestTypeDefinition.EVALUATE_ANNOTATIONS.getGovernanceRequestType(), null, null, null, null, null, RequestTypeDefinition.EVALUATE_ANNOTATIONS.getGovernanceEngine().getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step4GUID, SurveyActionGuard.SURVEY_COMPLETED.getName(), false, step5GUID);
        }
        if ((step6GUID = this.archiveHelper.addGovernanceActionProcessStep(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, processGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, OpenMetadataType.ASSET.typeName, null, qualifiedName + ":SetZones", "Publish asset (set governance zones)", "Set up the zones in the asset so that is it visible in the data lake.", 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            this.archiveHelper.addGovernanceActionExecutor(step6GUID, RequestTypeDefinition.ZONE_MEMBER.getGovernanceRequestType(), null, null, null, null, null, RequestTypeDefinition.ZONE_MEMBER.getGovernanceEngine().getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step3GUID, RetentionClassifierGuard.CLASSIFICATION_ASSIGNED.getName(), true, step6GUID);
            this.archiveHelper.addNextGovernanceActionProcessStep(step5GUID, EvaluateAnnotationsGuard.ACTIONS_ACTIONED.getName(), true, step6GUID);
        }
    }

    public void writeOpenMetadataArchive() {
        try {
            System.out.println("Writing to file: CocoGovernanceEngineDefinitionsArchive.omarchive");
            super.writeOpenMetadataArchive(archiveFileName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + String.valueOf(error));
        }
    }
}

