/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceengines;

import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileGovernanceActionProvider;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceServiceProviderBase;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceProvider;
import org.odpi.openmetadata.samples.archiveutilities.GovernanceActionDescription;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialCertifyHospitalProvider;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialCertifyWeeklyMeasurementsProvider;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialHospitalOnboardingProvider;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialNominateHospitalProvider;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialSetUpDataLakeProvider;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialSetUpProvider;

public enum CocoGovernanceServiceDefinition {
    SET_UP_CLINICAL_TRIAL("61417d87-509b-4ac6-9ff3-45dccd9b8c95", "set-up-clinical-trial-governance-action-service", "Set up new clinical trial", (GovernanceServiceProviderBase)new CocoClinicalTrialSetUpProvider(), ResourceUse.PROVISION_RESOURCE, DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR),
    SET_UP_DATA_LAKE("422d2711-a333-4188-98ca-aa09fcee5a6d", "set-up-data-lake-for-clinical-trial-governance-action-service", "Set up Data Lake to capture weekly patient measurements", (GovernanceServiceProviderBase)new CocoClinicalTrialSetUpDataLakeProvider(), ResourceUse.PROVISION_RESOURCE, DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR),
    NOMINATE_HOSPITAL("d6f3540f-d187-46bf-9e43-7dc410417ca2", "nominate-hospital-for-clinical-trial-governance-action-service", "Nominate a hospital has legal and data management arrangements in place to capture and supply weekly patient measurements as part of a clinical trial.", (GovernanceServiceProviderBase)new CocoClinicalTrialNominateHospitalProvider(), ResourceUse.PROVISION_RESOURCE, DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR),
    CERTIFY_HOSPITAL("ababa090-2a39-42cb-8214-6f6b44a10c7d", "certify-hospital-for-clinical-trial-governance-action-service", "Certify that a hospital has legal and data management arrangements in place to capture and supply weekly patient measurements as part of a clinical trial.", (GovernanceServiceProviderBase)new CocoClinicalTrialCertifyHospitalProvider(), ResourceUse.CERTIFY_RESOURCE, DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR),
    HOSPITAL_ONBOARDING("d3c663a9-83d3-4437-bbf7-9df1a62b8fa6", "onboard-hospital-for-clinical-trial-governance-action-service", "Onboard a Hospital into a Clinical Trial Governance Action Service", (GovernanceServiceProviderBase)new CocoClinicalTrialHospitalOnboardingProvider(), ResourceUse.PROVISION_RESOURCE, DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR),
    WEEKLY_MEASUREMENTS_DATA_QUALITY("580a9730-eab0-4aa9-a786-3a0c544bae40", "weekly-measurements-data-quality-survey-action-service", "Validate that the data in a weekly measurements file passes data validation checks.", (GovernanceServiceProviderBase)new CocoClinicalTrialCertifyWeeklyMeasurementsProvider(), ResourceUse.VALIDATE_RESOURCE, DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR),
    FILE_PROVISIONER("11192250-eaf6-4e3a-9ded-a3432c4b0e3d", "simulate-ftp-governance-action-service", "File Copy Governance Action Service", (GovernanceServiceProviderBase)new MoveCopyFileGovernanceActionProvider(), ResourceUse.PROVISION_RESOURCE, DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR);

    private final String guid;
    private final String name;
    private final String displayName;
    private final GovernanceServiceProviderBase connectorProvider;
    private final ResourceUse resourceUse;
    private final DeployedImplementationType deployedImplementationType;

    private CocoGovernanceServiceDefinition(String guid, String name, String displayName, GovernanceServiceProviderBase connectorProvider, ResourceUse resourceUse, DeployedImplementationType deployedImplementationType) {
        this.guid = guid;
        this.name = name;
        this.displayName = displayName;
        this.connectorProvider = connectorProvider;
        this.resourceUse = resourceUse;
        this.deployedImplementationType = deployedImplementationType;
    }

    public String getGUID() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.connectorProvider.getConnectorType().getDescription();
    }

    public String getConnectorProviderClassName() {
        return this.connectorProvider.getClass().getName();
    }

    public DeployedImplementationType getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public GovernanceActionDescription getGovernanceActionDescription() {
        GovernanceActionDescription governanceActionDescription = new GovernanceActionDescription();
        governanceActionDescription.governanceServiceGUID = this.guid;
        governanceActionDescription.resourceUse = this.resourceUse;
        governanceActionDescription.supportedTechnologies = this.connectorProvider.getSupportedTechnologyTypes();
        governanceActionDescription.supportedRequestTypes = this.connectorProvider.getSupportedRequestTypes();
        governanceActionDescription.supportedRequestParameters = this.connectorProvider.getSupportedRequestParameters();
        governanceActionDescription.supportedActionTargets = this.connectorProvider.getSupportedActionTargetTypes();
        governanceActionDescription.producedRequestParameters = this.connectorProvider.getProducedRequestParameters();
        governanceActionDescription.producedActionTargets = this.connectorProvider.getProducedActionTargetTypes();
        governanceActionDescription.producedGuards = this.connectorProvider.getProducedGuards();
        GovernanceServiceProviderBase governanceServiceProviderBase = this.connectorProvider;
        if (governanceServiceProviderBase instanceof SurveyActionServiceProvider) {
            SurveyActionServiceProvider surveyActionServiceProvider = (SurveyActionServiceProvider)governanceServiceProviderBase;
            governanceActionDescription.supportedAnalysisSteps = surveyActionServiceProvider.getSupportedAnalysisSteps();
            governanceActionDescription.supportedAnnotationTypes = surveyActionServiceProvider.getProducedAnnotationTypes();
        }
        governanceActionDescription.governanceServiceDescription = this.getDescription();
        return governanceActionDescription;
    }

    public String toString() {
        return "GovernanceServiceDefinition{name='" + this.name + "'}";
    }
}

