/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceengines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.archiveutilities.openconnectors.IntegrationConnectorDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.samples.archiveutilities.governanceengines.CocoGovernanceEngineDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceengines.CocoGovernanceServiceDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CertificationTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.ProjectDefinition;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialActionTarget;

public enum CocoRequestTypeDefinition {
    SET_UP_DATA_LAKE("set-up-data-lake", null, null, null, CocoGovernanceEngineDefinition.CLINICAL_TRIALS_ENGINE, CocoGovernanceServiceDefinition.SET_UP_DATA_LAKE, "4c33571b-043b-4fba-9b4f-ada7cd8910d3", ProjectDefinition.CLINICAL_TRIALS.getQualifiedName()),
    NOMINATE_HOSPITAL("nominate-hospital", null, null, null, CocoGovernanceEngineDefinition.CLINICAL_TRIALS_ENGINE, CocoGovernanceServiceDefinition.NOMINATE_HOSPITAL, "25f1f005-d051-4f78-a56a-7b94eda114aa", ProjectDefinition.CLINICAL_TRIALS.getQualifiedName()),
    CERTIFY_HOSPITAL("certify-hospital", null, null, null, CocoGovernanceEngineDefinition.CLINICAL_TRIALS_ENGINE, CocoGovernanceServiceDefinition.CERTIFY_HOSPITAL, "12746ea1-750b-43ef-b6d8-74c145c0d18c", ProjectDefinition.CLINICAL_TRIALS.getQualifiedName()),
    ONBOARD_HOSPITAL("onboard-hospital", null, null, null, CocoGovernanceEngineDefinition.CLINICAL_TRIALS_ENGINE, CocoGovernanceServiceDefinition.HOSPITAL_ONBOARDING, "7d12e715-53c6-4c33-bc05-7db9156056c8", ProjectDefinition.CLINICAL_TRIALS.getQualifiedName()),
    CHECK_DATA("check-weekly-measurements-data-quality", null, null, null, CocoGovernanceEngineDefinition.ASSET_QUALITY_ENGINE, CocoGovernanceServiceDefinition.WEEKLY_MEASUREMENTS_DATA_QUALITY, "7494e350-1478-491a-90c1-e22856a47372", ProjectDefinition.CLINICAL_TRIALS.getQualifiedName()),
    SET_UP_CLINICAL_TRIAL("set-up-clinical-trial", null, null, CocoRequestTypeDefinition.getSetUpActionTargets(), CocoGovernanceEngineDefinition.CLINICAL_TRIALS_ENGINE, CocoGovernanceServiceDefinition.SET_UP_CLINICAL_TRIAL, "23ceab08-f644-49c7-b7f3-95f39fe41c84", ProjectDefinition.CLINICAL_TRIALS.getQualifiedName()),
    SIMULATE_FTP("simulate-ftp", "copy-file", CocoRequestTypeDefinition.getNoLineageRequestParameter(), null, CocoGovernanceEngineDefinition.CLINICAL_TRIALS_ENGINE, CocoGovernanceServiceDefinition.FILE_PROVISIONER, "286599f7-8f05-4378-84f0-7e9af5dfad7f", ProjectDefinition.CLINICAL_TRIALS.getQualifiedName());

    private final String governanceRequestType;
    private final String serviceRequestType;
    private final Map<String, String> requestParameters;
    private final List<NewActionTarget> actionTargets;
    private final CocoGovernanceEngineDefinition governanceEngine;
    private final CocoGovernanceServiceDefinition governanceService;
    private final String governanceActionTypeGUID;
    private final String supportedElementQualifiedName;

    static Map<String, String> getNoLineageRequestParameter() {
        String noLineagePropertyName = "noLineage";
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("noLineage", "");
        return requestParameters;
    }

    static List<NewActionTarget> getSetUpActionTargets() {
        ArrayList<NewActionTarget> actionTargetList = new ArrayList<NewActionTarget>();
        NewActionTarget newActionTarget = new NewActionTarget();
        newActionTarget.setActionTargetName(CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName());
        newActionTarget.setActionTargetGUID(CertificationTypeDefinition.DROP_FOOT_APPROVED_HOSPITAL.getGUID());
        actionTargetList.add(newActionTarget);
        newActionTarget = new NewActionTarget();
        newActionTarget.setActionTargetName(CocoClinicalTrialActionTarget.DATA_QUALITY_CERTIFICATION_TYPE.getName());
        newActionTarget.setActionTargetGUID(CertificationTypeDefinition.DROP_FOOT_APPROVED_DATA.getGUID());
        actionTargetList.add(newActionTarget);
        newActionTarget = new NewActionTarget();
        newActionTarget.setActionTargetName(CocoClinicalTrialActionTarget.GENERIC_SET_UP_DATA_LAKE_GAT.getName());
        newActionTarget.setActionTargetGUID(CocoRequestTypeDefinition.SET_UP_DATA_LAKE.governanceActionTypeGUID);
        actionTargetList.add(newActionTarget);
        newActionTarget = new NewActionTarget();
        newActionTarget.setActionTargetName(CocoClinicalTrialActionTarget.GENERIC_HOSPITAL_NOMINATION_GAT.getName());
        newActionTarget.setActionTargetGUID(CocoRequestTypeDefinition.NOMINATE_HOSPITAL.governanceActionTypeGUID);
        actionTargetList.add(newActionTarget);
        newActionTarget = new NewActionTarget();
        newActionTarget.setActionTargetName(CocoClinicalTrialActionTarget.GENERIC_HOSPITAL_CERTIFICATION_GAT.getName());
        newActionTarget.setActionTargetGUID(CocoRequestTypeDefinition.CERTIFY_HOSPITAL.governanceActionTypeGUID);
        actionTargetList.add(newActionTarget);
        newActionTarget = new NewActionTarget();
        newActionTarget.setActionTargetName(CocoClinicalTrialActionTarget.GENERIC_HOSPITAL_ONBOARDING_GAT.getName());
        newActionTarget.setActionTargetGUID(CocoRequestTypeDefinition.ONBOARD_HOSPITAL.governanceActionTypeGUID);
        actionTargetList.add(newActionTarget);
        newActionTarget = new NewActionTarget();
        newActionTarget.setActionTargetName(CocoClinicalTrialActionTarget.LAST_UPDATE_CONNECTOR.getName());
        newActionTarget.setActionTargetGUID(IntegrationConnectorDefinition.MAINTAIN_LAST_UPDATE_CATALOGUER.getGUID());
        actionTargetList.add(newActionTarget);
        newActionTarget = new NewActionTarget();
        newActionTarget.setActionTargetName(CocoClinicalTrialActionTarget.LANDING_AREA_CONNECTOR.getName());
        newActionTarget.setActionTargetGUID(IntegrationConnectorDefinition.GENERAL_FOLDER_CATALOGUER.getGUID());
        actionTargetList.add(newActionTarget);
        return actionTargetList;
    }

    private CocoRequestTypeDefinition(String governanceRequestType, String serviceRequestType, Map<String, String> requestParameters, List<NewActionTarget> actionTargets, CocoGovernanceEngineDefinition governanceEngine, CocoGovernanceServiceDefinition governanceService, String governanceActionTypeGUID, String supportedElementQualifiedName) {
        this.governanceRequestType = governanceRequestType;
        this.serviceRequestType = serviceRequestType;
        this.requestParameters = requestParameters;
        this.actionTargets = actionTargets;
        this.governanceEngine = governanceEngine;
        this.governanceService = governanceService;
        this.governanceActionTypeGUID = governanceActionTypeGUID;
        this.supportedElementQualifiedName = supportedElementQualifiedName;
    }

    public String getGovernanceRequestType() {
        return this.governanceRequestType;
    }

    public String getServiceRequestType() {
        return this.serviceRequestType;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public List<NewActionTarget> getActionTargets() {
        return this.actionTargets;
    }

    public CocoGovernanceEngineDefinition getGovernanceEngine() {
        return this.governanceEngine;
    }

    public CocoGovernanceServiceDefinition getGovernanceService() {
        return this.governanceService;
    }

    public String getGovernanceActionTypeGUID() {
        return this.governanceActionTypeGUID;
    }

    public String getSupportedElementQualifiedName() {
        return this.supportedElementQualifiedName;
    }

    public String toString() {
        return "RequestTypeDefinition{name='" + this.governanceRequestType + "'}";
    }
}

