/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

public enum CocoGovernanceZoneDefinition {
    PERSONAL("personal-files", "Personal Files Zone", "Assets that are for an individual's use.  Initially the creator of the asset is the owner. This person can reassign the asset to additional zones to increase its visibility or reassign the ownership.", "Assets that should only be visible and editable to the owner."),
    QUARANTINE("quarantine", "Quarantine Zone", "Resources from third parties that are being evaluated by the onboarding team. The assets will move into the other zones once the asset has been catalogued and classified.", "Data sets just received and have not yet been properly catalogued."),
    LANDING_AREA("landing-area", "Landing Area Zone", "Denotes resources from third parties in their initial form. These resources will be copied and augmented by various onboarding processes.", "Original data sets received from third parties that have not been moved or transformed."),
    DATA_LAKE("data-lake", "Data Lake Zone", "Assets for sharing that are read only.", "These are production assets that can be used for business decisions."),
    RESEARCH("research", "Research Zone", "Research data sets and findings", "Assets that are driving the development of new products and techniques."),
    CLINICAL_TRIALS("clinical-trials", "Clinical Trials Zone", "Patient data, protocols, outcomes and analysis used within a clinical trial.This data is highly confidential and has restricted access.  It is also subject to the data management requirements of the regulators.", "Asset supporting the clinical trials."),
    HUMAN_RESOURCES("human-resources", "Human Resources (Personnel) Zone", "Assets used to manage and support employees of Coco Pharmaceuticals.", "Assets controlled by the HR and management teams."),
    FINANCE("finance", "Finance Zone", "Assets that support the financial management of Coco Pharmaceuticals.", "Assets controlled by the finance team."),
    INFRASTRUCTURE("infrastructure", "IT Infrastructure Zone", "Assets that describe the IT infrastructure such as hosts, servers, applications, databases and network infrastructure descriptions.", "Assets controlled by the IT Infrastructure team."),
    DEVELOPMENT("development", "Development and DevOps Zone", "Software development components and assets that support their ongoing development.", "Software development and devops assets."),
    MANUFACTURING("manufacturing", "Supply, Manufacturing and Distribution Zone", "Suppliers, manufacturing infrastructure, schedules and outputs.", "These are the assets that support the production of Coco Pharmaceutical's products."),
    SALES("sales", "Sales Zone", "Customers, sales plans, orders and fulfilment tracking.", "Assets supported by the sales teams."),
    GOVERNANCE("governance", "Governance Zone", "Governance definitions, monitoring and reporting assets.", "Assets that support the governance team"),
    TRASH_CAN("trash-can", "Trash Can Zone", "Asset that are in a holding zone ready to be deleted.", "Assets that are no longer required."),
    SUSTAINABILITY("sustainability", "Sustainability Reporting", "Assets used to build reports that illustrate the status of Coco Pharmaceutical's greenhouse gas emissions and sustainability initiatives.", "Activity data that relates to sustainability");

    private final String zoneName;
    private final String displayName;
    private final String description;
    private final String criteria;

    private CocoGovernanceZoneDefinition(String zoneName, String displayName, String description, String criteria) {
        this.zoneName = zoneName;
        this.displayName = displayName;
        this.description = description;
        this.criteria = criteria;
    }

    public String getQualifiedName() {
        return "GovernanceZone::" + this.zoneName;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCriteria() {
        return this.criteria;
    }
}

