/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.GovernanceDomainDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.ScopeDefinition;

public enum CocoSubjectAreaDefinition {
    ORGANIZATION("Organization", null, "Organization", "Information relating to an organization.", ScopeDefinition.ALL_COCO.getPreferredValue(), "Controlling data management relating to different types of organizational structures and catalogues.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    HOSPITAL("Organization:Hospital", ORGANIZATION, "Hospital", "Information relating to a hospital's organization.", ScopeDefinition.ALL_COCO.getPreferredValue(), "Controlling data management relating to different types of hospital organizational structures and catalogues.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    SUPPLIER("Organization:Supplier", ORGANIZATION, "Supplier", "Information relating to a supplier's organization.", ScopeDefinition.ALL_COCO.getPreferredValue(), "Controlling data management relating to different types of supplier organizational structures and catalogues.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    PERSON("Person", null, "Person", "Information relating to an individual.", ScopeDefinition.ALL_COCO.getPreferredValue(), "Controlling data management relating to information that describes an individual.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    PATIENT("Person:Patient", PERSON, "Patient", "Information relating to an individual patient.", ScopeDefinition.ALL_COCO.getPreferredValue(), "Controlling data management relating to information that describes an individual patient.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    CLINICIAN("Person:Clinician", PERSON, "Clinician", "Information relating to an individual who works with patients.", ScopeDefinition.ALL_COCO.getPreferredValue(), "Controlling data management relating to information that describes an individual working with patients.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    EMPLOYEE("Person:Employee", PERSON, "Employee", "Information relating to an individual who is employed by an organization.", ScopeDefinition.ALL_COCO.getPreferredValue(), "Controlling data management relating to information that describes an employee.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    COLLABORATOR("Person:Collaborator", PERSON, "Collaborator", "Information relating to an individual who works for a business partner.", ScopeDefinition.ALL_COCO.getPreferredValue(), "Controlling data management relating to information that describes an individuals who are business partners.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    CLINICAL("Clinical", null, "Clinical", "Information relating to the work understanding medical conditions and their resolution.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    SYMPTOM("Clinical:Symptom", CLINICAL, "Clinical", "Information relating to the symptoms of a medical condition.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    MEASUREMENT("Clinical:Measurement", CLINICAL, "Measurement", "Information relating to the measurements taken to understanding medical conditions and their effectiveness.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    PRESCRIPTION("Clinical:Prescription", CLINICAL, "Prescription", "Information relating to the treatment defined for a specific patient.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    OUTCOME("Clinical:Outcome", CLINICAL, "Outcome", "Information relating to the work understanding the result of a course of treatment.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    TREATMENT("Treatment", null, "Treatment", "Information relating to the Coco Pharmaceutical products and practices around patient care.", "Within research, sales, manufacturing and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' treatments.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    PRODUCT("Treatment:Product", TREATMENT, "Product", "Information relating to the Coco Pharmaceutical products to be used in particular treatments.", "Within research, sales, manufacturing and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' treatments.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    ORDER("Treatment:Order", TREATMENT, "Order", "Information relating to orders for Coco Pharmaceutical products.", "Within research, sales, manufacturing and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' treatments.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    RECIPE("Treatment:Recipe", TREATMENT, "Recipe", "Information relating to the ingredients and manufacturing know-how for Coco Pharmaceutical products.", "Within research, sales, manufacturing and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' treatments.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    SERVICE_QUALITY("ServiceQuality", null, "Service Quality", "Information relating to the Coco Pharmaceuticals' business operations.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    CONTRACT("ServiceQuality:Contract", SERVICE_QUALITY, "Contract", "Information relating to the Coco Pharmaceuticals' contracts.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    STOCK("ServiceQuality:Stock", SERVICE_QUALITY, "Stock", "Information relating to the Coco Pharmaceuticals' stock management and control.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    DISTRIBUTION("ServiceQuality:Distribution", SERVICE_QUALITY, "Distribution", "Information relating to the Coco Pharmaceuticals' distribution of treatments.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    INVOICE("ServiceQuality:Invoice", SERVICE_QUALITY, "Invoice", "Information relating to the Coco Pharmaceuticals' billing and payments.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    GOVERNANCE("Governance", null, "Governance", "Information relating to the Coco Pharmaceuticals' governance initiatives.", "Within research, sales, manufacturing, finance and the data lake.", "Education on the terminology associated with a governance domain", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    PRODUCT_DEVELOPMENT("ProductDevelopment", null, "Product Development", "Information relating to the Coco Pharmaceuticals' treatment development initiatives.", "Within research and the board.", "Coordinating and regulating data during the development of new treatments", GovernanceDomainDefinition.ALL.getDomainIdentifier()),
    CLINICAL_TRIAL("ProductDevelopment:ClinicalTrial", PRODUCT_DEVELOPMENT, "Clinical Trial", "Information relating to the clinical trials run to support Coco Pharmaceuticals' product development initiatives.", "Within research and the board.", "Coordinating and regulating data during a clinical trial.", GovernanceDomainDefinition.ALL.getDomainIdentifier());

    private final String subjectAreaName;
    private final CocoSubjectAreaDefinition parent;
    private final String displayName;
    private final String description;
    private final String scope;
    private final String usage;
    private final int domain;

    private CocoSubjectAreaDefinition(String name, CocoSubjectAreaDefinition parent, String displayName, String description, String scope, String usage, int domain) {
        this.subjectAreaName = name;
        this.parent = parent;
        this.displayName = displayName;
        this.description = description;
        this.scope = scope;
        this.usage = usage;
        this.domain = domain;
    }

    public String getQualifiedName() {
        return "SubjectArea::" + this.subjectAreaName;
    }

    public String getSubjectAreaName() {
        return this.subjectAreaName;
    }

    public CocoSubjectAreaDefinition getParent() {
        return this.parent;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScope() {
        return this.scope;
    }

    public String getUsage() {
        return this.usage;
    }

    public int getDomain() {
        return this.domain;
    }

    public String toString() {
        return "CocoSubjectAreaDefinition{subjectAreaName='" + this.subjectAreaName + "'}";
    }
}

