/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;

public enum CommunityDefinition {
    DATA_SCI_SIG("SIG:DataSci", "Data Science special interest group", "Community of data scientists within Coco Pharmaceuticals.", new PersonDefinition[]{PersonDefinition.CALLIE_QUARTILE}, new PersonDefinition[]{PersonDefinition.TESSA_TUBE, PersonDefinition.ERIN_OVERVIEW, PersonDefinition.STEW_FASTER, PersonDefinition.TERRI_DARING, PersonDefinition.STEVE_STARTER, PersonDefinition.TOM_TALLY});

    private final String qualifiedName;
    private final String displayName;
    private final String description;
    private final PersonDefinition[] leaders;
    private final PersonDefinition[] members;

    private CommunityDefinition(String qualifiedName, String displayName, String description, PersonDefinition[] leaders, PersonDefinition[] members) {
        this.qualifiedName = qualifiedName;
        this.displayName = displayName;
        this.description = description;
        this.leaders = leaders;
        this.members = members;
    }

    public String getQualifiedName() {
        return "Community:: " + this.qualifiedName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PersonDefinition> getLeaders() {
        return Arrays.asList(this.leaders);
    }

    public List<PersonDefinition> getMembers() {
        return Arrays.asList(this.members);
    }

    public String toString() {
        return "CommunityDefinition{" + this.displayName + "}";
    }
}

