/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ProjectStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;

public enum ProjectDefinition {
    MANUFACTURING_MOD("Campaign:Manufacturing Modernization", "CAMP-MM", "Manufacturing Modernization Project", "Project to upgrade manufacturing process to support personalized medicine.", true, false, null, ProjectStatus.ACTIVATING, null, null, PersonDefinition.STEW_FASTER, null),
    CLINICAL_TRIALS("Campaign:Clinical Trials Management", "CAMP-CT", "Clinical Trials Management", "Developing efficient ways to manage each of the clinical trials.", true, false, OpenMetadataType.GOVERNANCE_PROJECT_CLASSIFICATION.typeName, ProjectStatus.ACTIVE, null, null, PersonDefinition.TANYA_TIDIE, null);

    private final String qualifiedName;
    private final String identifier;
    private final String displayName;
    private final String description;
    private final boolean isCampaign;
    private final boolean isTask;
    private final String projectTypeClassification;
    private final ProjectStatus projectStatus;
    private final ProjectDefinition controllingProject;
    private final ProjectDefinition[] dependentOn;
    private final PersonDefinition leader;
    private final PersonDefinition[] members;

    private ProjectDefinition(String qualifiedName, String identifier, String displayName, String description, boolean isCampaign, boolean isTask, String projectTypeClassification, ProjectStatus projectStatus, ProjectDefinition controllingProject, ProjectDefinition[] dependentOn, PersonDefinition leader, PersonDefinition[] members) {
        this.qualifiedName = qualifiedName;
        this.identifier = identifier;
        this.displayName = displayName;
        this.description = description;
        this.isCampaign = isCampaign;
        this.isTask = isTask;
        this.projectTypeClassification = projectTypeClassification;
        this.projectStatus = projectStatus;
        this.dependentOn = dependentOn;
        this.controllingProject = controllingProject;
        this.leader = leader;
        this.members = members;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCampaign() {
        return this.isCampaign;
    }

    public boolean isTask() {
        return this.isTask;
    }

    public String getProjectTypeClassification() {
        return this.projectTypeClassification;
    }

    public ProjectStatus getProjectStatus() {
        return this.projectStatus;
    }

    public ProjectDefinition getControllingProject() {
        return this.controllingProject;
    }

    public List<ProjectDefinition> getDependentOn() {
        if (this.dependentOn != null) {
            return Arrays.asList(this.dependentOn);
        }
        return null;
    }

    public PersonDefinition getLeader() {
        return this.leader;
    }

    public List<PersonDefinition> getMembers() {
        if (this.members != null) {
            return Arrays.asList(this.members);
        }
        return null;
    }

    public String toString() {
        return "ProjectDefinition{" + this.displayName + "}";
    }
}

