/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

public enum BusinessAreaDefinition {
    RESEARCH("RES", "Research", "Scientific exploration, discovery and validation of new treatments for cancer."),
    CLINICAL_TRIALS("C-TRI", "Clinical Trials", "Formal validation of new treatments for cancer with patients."),
    FINANCE("FIN", "Finance", "Management of cash flow and financial health of Coco Pharmaceuticals."),
    HR("HR", "Human Resources", "Management of people, their skills and well-being for Coco Pharmaceuticals."),
    IT("IT", "IT", "Provision of computing services for Coco Pharmaceuticals."),
    MANUFACTURING("MFG", "Manufacturing", "Production of Coco Pharmaceuticals' products."),
    DISTRIBUTION("DIST", "Distribution", "Warehouse management and distribution of Coco Pharmaceuticals' products to customers."),
    SALES("SALES", "Sales", "Managing customer relationships in order to sell them appropriate Coco Pharmaceuticals' products."),
    GOVERNANCE("GOV", "Governance", "Management of how Coco Pharmaceuticals operates, balancing business strategy and profits against ethics, legal requirements and regulations.");

    private final String identifier;
    private final String displayName;
    private final String description;

    private BusinessAreaDefinition(String identifier, String displayName, String description) {
        this.identifier = identifier;
        this.displayName = displayName;
        this.description = description;
    }

    public String getQualifiedName() {
        return "BusinessArea::" + this.identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "BusinessAreaDefinition{" + this.displayName + "}";
    }
}

