/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.samples.archiveutilities.organization.BusinessAreaDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.ScopeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.WorkLocationDefinition;

public enum DeptDefinition {
    BOARD("4302", "Board", "Members of the Board of Coco Pharmaceuticals.", null, new PersonDefinition[]{PersonDefinition.ZACH_NOW, PersonDefinition.TERRI_DARING, PersonDefinition.STEVE_STARTER}, new PersonDefinition[]{PersonDefinition.REGGIE_MINT, PersonDefinition.JULES_KEEPER, PersonDefinition.FAITH_BROKER, PersonDefinition.IVOR_PADLOCK, PersonDefinition.STEW_FASTER}, 0, null, BusinessAreaDefinition.GOVERNANCE, ScopeDefinition.ALL_COCO),
    FOUNDERS("9999", "Founders Team", "Founders of Coco Pharmaceuticals.", null, new PersonDefinition[]{PersonDefinition.ZACH_NOW, PersonDefinition.TERRI_DARING, PersonDefinition.STEVE_STARTER}, null, 0, null, BusinessAreaDefinition.GOVERNANCE, ScopeDefinition.ALL_COCO),
    AMSTERDAM("9998", "Amsterdam Site", "Amsterdam Employees", FOUNDERS, new PersonDefinition[]{PersonDefinition.STEVE_STARTER}, null, 1, WorkLocationDefinition.AMSTERDAM_SITE, null, ScopeDefinition.WITHIN_SITE),
    HR_GLOBAL("9657", "Human Resources", "Human Resources for Coco Pharmaceuticals.", BOARD, new PersonDefinition[]{PersonDefinition.FAITH_BROKER}, null, 3, WorkLocationDefinition.AMSTERDAM_SITE, BusinessAreaDefinition.HR, ScopeDefinition.ALL_COCO),
    SEC_GLOBAL("0001", "Security", "Security for Coco Pharmaceuticals.", BOARD, new PersonDefinition[]{PersonDefinition.IVOR_PADLOCK}, null, 2, WorkLocationDefinition.AMSTERDAM_SITE, BusinessAreaDefinition.GOVERNANCE, ScopeDefinition.ALL_COCO),
    SALES_EU("0002", "Sales", "Team selling Coco Pharmaceuticals products to hospitals in EU.", AMSTERDAM, null, null, 5, WorkLocationDefinition.AMSTERDAM_SITE, BusinessAreaDefinition.SALES, ScopeDefinition.WITHIN_REGION),
    AMSTERDAM_LAB("2373", "Van Leeuwenhoek Lab Team", "Amsterdam researchers.", AMSTERDAM, new PersonDefinition[]{PersonDefinition.STEVE_STARTER}, null, 12, WorkLocationDefinition.AMSTERDAM_SITE, BusinessAreaDefinition.RESEARCH, ScopeDefinition.WITHIN_SITE),
    CLINICAL_TRIALS_EU("0003", "Clinical Trials Team (EU)", "Team coordinating the clinical trials with a variety of hospitals in the EU.", AMSTERDAM, null, null, 8, WorkLocationDefinition.AMSTERDAM_SITE, BusinessAreaDefinition.CLINICAL_TRIALS, ScopeDefinition.WITHIN_REGION),
    IT_GLOBAL("0004", "Global Information Technology Team", "Team managing shared IT resources for Coco Pharmaceuticals.", AMSTERDAM, new PersonDefinition[]{PersonDefinition.STEVE_STARTER}, new PersonDefinition[]{PersonDefinition.GARY_GEEKE, PersonDefinition.POLLY_TASKER}, 0, WorkLocationDefinition.AMSTERDAM_SITE, BusinessAreaDefinition.IT, ScopeDefinition.ALL_COCO),
    SE_GLOBAL("3082", "Software Development and Testing Team", "Team managing bespoke software development for Coco Pharmaceuticals.", IT_GLOBAL, new PersonDefinition[]{PersonDefinition.POLLY_TASKER}, new PersonDefinition[]{PersonDefinition.BOB_NITTER, PersonDefinition.LEMMIE_STAGE, PersonDefinition.NANCY_NOAH, PersonDefinition.DES_SIGNA}, 1, WorkLocationDefinition.AMSTERDAM_SITE, null, ScopeDefinition.ALL_COCO),
    IT_OPS_GLOBAL("3067", "IT Operations Team", "Team managing shared IT resources for Coco Pharmaceuticals.", IT_GLOBAL, new PersonDefinition[]{PersonDefinition.GARY_GEEKE}, null, 2, WorkLocationDefinition.AMSTERDAM_SITE, null, ScopeDefinition.ALL_COCO),
    AMSTERDAM_DEPOT("0005", "Amsterdam Depot", "Team managing the warehouse and distribution for the EU.", AMSTERDAM, null, null, 6, WorkLocationDefinition.AMSTERDAM_SITE, BusinessAreaDefinition.DISTRIBUTION, ScopeDefinition.WITHIN_REGION),
    LONDON("9997", "London Site", "London Employees", FOUNDERS, new PersonDefinition[]{PersonDefinition.TERRI_DARING}, null, 1, WorkLocationDefinition.LONDON_SITE, null, ScopeDefinition.WITHIN_SITE),
    LONDON_LAB("5656", "Nightingale Lab Team", "London researchers.", LONDON, new PersonDefinition[]{PersonDefinition.TERRI_DARING}, null, 7, WorkLocationDefinition.LONDON_SITE, BusinessAreaDefinition.RESEARCH, ScopeDefinition.WITHIN_SITE),
    CLINICAL_TRIALS_UK("0006", "Clinical Trials Team (UK)", "Team coordinating the clinical trials with a variety of hospitals in the UK.", LONDON, null, null, 2, WorkLocationDefinition.LONDON_SITE, BusinessAreaDefinition.CLINICAL_TRIALS, ScopeDefinition.WITHIN_REGION),
    CDO("7432", "Chief Data Office", "Team focusing on data value, use and governance within Coco Pharmaceuticals.", BOARD, new PersonDefinition[]{PersonDefinition.JULES_KEEPER}, new PersonDefinition[]{PersonDefinition.ERIN_OVERVIEW, PersonDefinition.PETER_PROFILE}, 2, WorkLocationDefinition.LONDON_SITE, BusinessAreaDefinition.GOVERNANCE, ScopeDefinition.ALL_COCO),
    FINANCE("6788", "Finance Team", "Team responsible for the financial health of Coco Pharmaceuticals.", BOARD, new PersonDefinition[]{PersonDefinition.REGGIE_MINT}, new PersonDefinition[]{PersonDefinition.TOM_TALLY, PersonDefinition.SIDNEY_SEEKER}, 1, WorkLocationDefinition.LONDON_SITE, BusinessAreaDefinition.FINANCE, ScopeDefinition.ALL_COCO),
    ACCOUNTS("6877", "Accounts Team", "Team accounting the cash flow through Coco Pharmaceuticals.", FINANCE, new PersonDefinition[]{PersonDefinition.TOM_TALLY}, new PersonDefinition[]{PersonDefinition.SALLY_COUNTER}, 4, WorkLocationDefinition.LONDON_SITE, null, ScopeDefinition.ALL_COCO),
    SALES_UK("0007", "Sales", "Team selling Coco Pharmaceuticals products to hospitals in UK.", LONDON, null, null, 4, WorkLocationDefinition.LONDON_SITE, BusinessAreaDefinition.SALES, ScopeDefinition.WITHIN_REGION),
    IT_LONDON("0008", "London Information Technology Team", "Team managing IT resources for Coco Pharmaceuticals Finance.", LONDON, null, null, 2, WorkLocationDefinition.LONDON_SITE, BusinessAreaDefinition.IT, ScopeDefinition.WITHIN_SITE),
    NEW_YORK("9996", "New York Site", "New York Employees", FOUNDERS, new PersonDefinition[]{PersonDefinition.ZACH_NOW}, null, 1, WorkLocationDefinition.NEW_YORK_SITE, null, ScopeDefinition.WITHIN_SITE),
    NEW_YORK_LAB("2343", "Salk Lab Team", "New York researchers.", NEW_YORK, new PersonDefinition[]{PersonDefinition.TESSA_TUBE}, null, 10, WorkLocationDefinition.NEW_YORK_SITE, BusinessAreaDefinition.RESEARCH, ScopeDefinition.WITHIN_SITE),
    CLINICAL_TRIALS_NA("4051", "Clinical Trials Team (NA)", "Team coordinating the clinical trials with a variety of hospitals in USA/Canada.", NEW_YORK_LAB, new PersonDefinition[]{PersonDefinition.TESSA_TUBE}, new PersonDefinition[]{PersonDefinition.CALLIE_QUARTILE, PersonDefinition.TANYA_TIDIE}, 8, WorkLocationDefinition.NEW_YORK_SITE, BusinessAreaDefinition.CLINICAL_TRIALS, ScopeDefinition.WITHIN_REGION),
    SALES_NA("0009", "Sales", "Team selling Coco Pharmaceuticals products to hospitals in NA.", NEW_YORK, new PersonDefinition[]{PersonDefinition.HARRY_HOPEFUL}, null, 6, WorkLocationDefinition.NEW_YORK_SITE, BusinessAreaDefinition.SALES, ScopeDefinition.WITHIN_REGION),
    IT_NY("0010", "New York Information Technology Team", "Team managing IT resources for New York Site.", NEW_YORK, null, null, 2, WorkLocationDefinition.NEW_YORK_SITE, BusinessAreaDefinition.IT, ScopeDefinition.WITHIN_SITE),
    AUSTIN("9995", "Austin Site", "Austin Employees", FOUNDERS, null, null, 1, WorkLocationDefinition.AUSTIN_SITE, null, ScopeDefinition.WITHIN_SITE),
    AUSTIN_PLANT("0011", "Austin Factory", "Team producing and delivering products to customers based in Austin, TX.", AUSTIN, null, null, 16, WorkLocationDefinition.AUSTIN_SITE, BusinessAreaDefinition.MANUFACTURING, ScopeDefinition.WITHIN_REGION),
    AUSTIN_OFFICE("0012", "Austin Office Team", "Team managing administration for Austin operation.", AUSTIN, null, null, 9, WorkLocationDefinition.AUSTIN_SITE, BusinessAreaDefinition.MANUFACTURING, ScopeDefinition.WITHIN_SITE),
    IT_AUSTIN("0013", "Austin Information Technology Team", "Team managing IT resources for Austin manufacturing.", AUSTIN, null, null, 4, WorkLocationDefinition.AUSTIN_SITE, BusinessAreaDefinition.IT, ScopeDefinition.WITHIN_SITE),
    WINCHESTER("9994", "Winchester Site", "Winchester Employees", FOUNDERS, new PersonDefinition[]{PersonDefinition.STEW_FASTER}, null, 1, WorkLocationDefinition.WINCHESTER_SITE, null, ScopeDefinition.WITHIN_SITE),
    WINCH_PLANT("0014", "Winchester Manufacturing", "Team responsible for producing and delivering products to customers based in Winchester, UK.", WINCHESTER, new PersonDefinition[]{PersonDefinition.STEW_FASTER}, null, 14, WorkLocationDefinition.WINCHESTER_SITE, BusinessAreaDefinition.MANUFACTURING, ScopeDefinition.WORLD),
    WINCH_OFFICE("0015", "Winchester Manufacturing Office", "Office team based in Winchester, UK.", WINCHESTER, new PersonDefinition[]{PersonDefinition.STEW_FASTER}, null, 0, WorkLocationDefinition.WINCHESTER_SITE, BusinessAreaDefinition.MANUFACTURING, ScopeDefinition.WORLD),
    WINCH_OFFICE_LOCAL("0016", "Winchester Manufacturing Office", "Team responsible for administration of the Winchester Manufacturing Operation based in Winchester, UK.", WINCH_OFFICE, null, null, 4, WorkLocationDefinition.WINCHESTER_SITE, BusinessAreaDefinition.MANUFACTURING, ScopeDefinition.WORLD),
    MANUFACTURING_GLOBAL("4332", "Global Manufacturing Office", "Team responsible for administration of the Global Manufacturing Operation based in Winchester, UK.", BOARD, new PersonDefinition[]{PersonDefinition.STEW_FASTER}, null, 5, WorkLocationDefinition.WINCHESTER_SITE, BusinessAreaDefinition.MANUFACTURING, ScopeDefinition.WORLD),
    IT_WINCH("0017", "Winchester Information Technology Team", "Team managing IT resources for Winchester manufacturing.", WINCHESTER, null, null, 5, WorkLocationDefinition.WINCHESTER_SITE, BusinessAreaDefinition.IT, ScopeDefinition.WITHIN_SITE),
    WINCH_DEPOT("0018", "Winchester Depot", "Team managing the warehouse and distribution for the UK.", WINCHESTER, null, null, 10, WorkLocationDefinition.WINCHESTER_SITE, BusinessAreaDefinition.DISTRIBUTION, ScopeDefinition.WITHIN_COUNTRY),
    KC("9993", "Kansas City Site", "Kansas City Employees", FOUNDERS, null, null, 1, WorkLocationDefinition.KANSAS_CITY_SITE, null, ScopeDefinition.WITHIN_SITE),
    KC_OFFICE("0019", "Kansas City Office Team", "Team managing administration for Kansas City operation.", KC, null, null, 3, WorkLocationDefinition.KANSAS_CITY_SITE, BusinessAreaDefinition.DISTRIBUTION, ScopeDefinition.WITHIN_SITE),
    KC_DEPOT("0020", "Kansas City Depot", "Team managing the warehouse and distribution for the USA.", KC, null, null, 7, WorkLocationDefinition.KANSAS_CITY_SITE, BusinessAreaDefinition.DISTRIBUTION, ScopeDefinition.WITHIN_COUNTRY),
    EDMONTON("9992", "Edmonton Site", "Edmonton Employees", FOUNDERS, null, null, 1, WorkLocationDefinition.EDMONTON_SITE, null, ScopeDefinition.WITHIN_SITE),
    EDMONTON_PLANT("0021", "Edmonton Factory", "Team producing and delivering products to customers based in Edmonton, CA.", AUSTIN, null, null, 17, WorkLocationDefinition.AUSTIN_SITE, BusinessAreaDefinition.MANUFACTURING, ScopeDefinition.WITHIN_REGION),
    EDMONTON_OFFICE("0022", "Edmonton Office Team", "Team managing administration for Edmonton operation.", EDMONTON, null, null, 4, WorkLocationDefinition.EDMONTON_SITE, BusinessAreaDefinition.MANUFACTURING, ScopeDefinition.WITHIN_SITE),
    IT_EDMONTON("0023", "Edmonton Information Technology Team", "Team managing IT resources for Edmonton operation.", EDMONTON, null, null, 3, WorkLocationDefinition.EDMONTON_SITE, BusinessAreaDefinition.IT, ScopeDefinition.WITHIN_SITE),
    EDMONTON_DEPOT("0024", "Edmonton Depot", "Team managing the warehouse and distribution for Canada.", EDMONTON, null, null, 5, WorkLocationDefinition.EDMONTON_SITE, BusinessAreaDefinition.DISTRIBUTION, ScopeDefinition.WITHIN_COUNTRY);

    private final String teamId;
    private final String displayName;
    private final String description;
    private final DeptDefinition superTeam;
    private final PersonDefinition[] leaders;
    private final PersonDefinition[] members;
    private final int additionalMembers;
    private final WorkLocationDefinition workLocation;
    private final BusinessAreaDefinition businessArea;
    private final ScopeDefinition businessAreaScope;

    private DeptDefinition(String teamId, String displayName, String description, DeptDefinition superTeam, PersonDefinition[] leaders, PersonDefinition[] members, int additionalMembers, WorkLocationDefinition workLocation, BusinessAreaDefinition businessArea, ScopeDefinition businessAreaScope) {
        this.teamId = teamId;
        this.displayName = displayName;
        this.description = description;
        this.superTeam = superTeam;
        this.leaders = leaders;
        this.members = members;
        this.additionalMembers = additionalMembers;
        this.workLocation = workLocation;
        this.businessArea = businessArea;
        this.businessAreaScope = businessAreaScope;
    }

    public String getQualifiedName() {
        return "Department::" + this.teamId;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public DeptDefinition getSuperTeam() {
        return this.superTeam;
    }

    public List<PersonDefinition> getLeaders() {
        if (this.leaders != null) {
            return Arrays.asList(this.leaders);
        }
        return null;
    }

    public List<PersonDefinition> getMembers() {
        if (this.members != null) {
            return Arrays.asList(this.members);
        }
        return null;
    }

    public int getAdditionalMembers() {
        return this.additionalMembers;
    }

    public WorkLocationDefinition getWorkLocation() {
        return this.workLocation;
    }

    public BusinessAreaDefinition getBusinessArea() {
        return this.businessArea;
    }

    public ScopeDefinition getBusinessAreaScope() {
        return this.businessAreaScope;
    }

    public String toString() {
        return "DeptDefinition{" + this.displayName + "}";
    }
}

