/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;

public enum ScopeDefinition {
    WORLD("The world", "Everyone, both inside and outside of Coco Pharmaceuticals."),
    ALL_COCO("Across Coco Pharmaceuticals", "All of Coco Pharmaceuticals."),
    WITHIN_REGION("Within Region", "Within the trading region (USA and Canada, UK, EU)."),
    WITHIN_COUNTRY("Within Country", "Within the local country."),
    WITHIN_BUSINESS_CAPABILITY("Within Business Capability", "Within a Business Area or Service."),
    WITHIN_DISCIPLINE("Within Discipline", "Within work of the same type performed by the same professionals for the same purposes."),
    WITHIN_TEAM("Within Team", "Within the team."),
    WITHIN_PROJECT("Within Project", "Within the project."),
    WITHIN_SOLUTION("Within Solution", "Within the solution."),
    WITHIN_SITE("Within Site", "Within the local site."),
    WITHIN_FACILITY("Within Facility", "Within the specific facility at the local site."),
    INDIVIDUAL("Individual", "Just for the individual."),
    TEMPLATE_PLACEHOLDER(PlaceholderProperty.SCOPE.getPlaceholder(), PlaceholderProperty.SCOPE.getName());

    public static final String validValueSetName = "Scope";
    public static final String validValueSetPropertyName = "scope";
    public static final String validValueSetDescription = "Identifies the scope of responsibility assigned to an individual term, person or activity.";
    public static final String validValueSetUsage = "Used in relationships and definition that imply responsibility.";
    public static final String validValueSetScope = "For properties relating to Coco Pharmaceuticals, their employees and partners.";
    private final String preferredValue;
    private final String displayName;

    private ScopeDefinition(String preferredValue, String displayName) {
        this.preferredValue = preferredValue;
        this.displayName = displayName;
    }

    public String getPreferredValue() {
        return this.preferredValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return "Scope{" + this.displayName + "}";
    }
}

