/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

import java.util.HashMap;
import java.util.Map;

public enum WorkLocationDefinition {
    AMSTERDAM_SITE("1", "Amsterdam", null, "1833", "Wilhelmdreef", "Amsterdam-Zuidoost", "Amsterdam", "North Holland", "Netherlands", "UTC+1"),
    LONDON_SITE("2", "London", null, "32", "Wibble Rd", "Corterville", "London", "Greater London", "United Kingdom", "UTC"),
    NEW_YORK_SITE("3", "New York", null, "27", "Code St", "Harlem", "New York", "NY", "United States", "UTC-5"),
    HAMPTON_HOSPITAL("4", "Hampton Hospital", "Oncology Unit 1, Hampton Hospital", null, "Nightingale St", "Harlem", "New York", "NY", "United States", "UTC-5"),
    OAK_DENE_HOSPITAL("5", "Oak Dene Hospital", null, "56", "Tile St", "St Cross", "Winchester", "Hampshire", "United Kingdom", "UTC"),
    OLD_MARKET_HOSPITAL("6", "Old Market Hospital", null, "10", "Hooplstrect", "North Holland", "Amsterdam", "North Holland", "Netherlands", "UTC+1"),
    AUSTIN_SITE("7", "Austin", null, "10000", "38th St", "Austin", "Austin", "TX", "USA", "UTC-6"),
    WINCHESTER_SITE("8", "Winchester", null, "1", "Eagles Nest", "", "Winchester", "Hampshire", "UK", "UTC"),
    KANSAS_CITY_SITE("9", "Kansas City", "Coco Distribution Center", "1200", "Industrial Parkway", "", "Kansas City", "KS", "USA", "UTC-6"),
    EDMONTON_SITE("10", "Edmonton", null, "10828", "102 Ave NW", "", "Edmonton", "Alberta", "Canada", "UTC-8"),
    BOWDEN_ARROW_HOSPITAL("11", "Bowden Arrow Hospital", "Main Building, Bowden Arrow Hospital", null, "Lake View St", null, "Chicago", "IL", "United States", "UTC-6");

    public static final String validValueSetName = "WorkLocation";
    public static final String validValueSetPropertyName = "workLocation";
    public static final String validValueSetDescription = "Describes the reason behind a team's formation.";
    public static final String validValueSetUsage = "Used as a tag to identify an employee's primary work location.";
    public static final String validValueSetScope = "Used for all types of people associated with Coco Pharmaceuticals.";
    private static final String BUILDING_NAME_PROPERTY = "buildingName";
    private static final String STREET_NUMBER_PROPERTY = "streetNumber";
    private static final String STREET_NAME_PROPERTY = "streetName";
    private static final String DISTRICT_NAME_PROPERTY = "district";
    private static final String CITY_NAME_PROPERTY = "city";
    private static final String AREA_NAME_PROPERTY = "area";
    private static final String COUNTRY_NAME_PROPERTY = "country";
    private final String workLocationId;
    private final String displayName;
    private final String buildingName;
    private final String streetNumber;
    private final String streetName;
    private final String district;
    private final String city;
    private final String area;
    private final String country;
    private final String timeZone;

    private WorkLocationDefinition(String workLocationId, String displayName, String buildingName, String streetNumber, String streetName, String district, String city, String area, String country, String timeZone) {
        this.workLocationId = workLocationId;
        this.displayName = displayName;
        this.buildingName = buildingName;
        this.streetNumber = streetNumber;
        this.streetName = streetName;
        this.district = district;
        this.city = city;
        this.area = area;
        this.country = country;
        this.timeZone = timeZone;
    }

    public String getQualifiedName() {
        return "WorkLocation." + this.workLocationId;
    }

    public String getWorkLocationId() {
        return this.workLocationId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPostalAddress() {
        String postalAddress = null;
        if (this.buildingName != null) {
            postalAddress = this.buildingName + ", ";
        }
        if (this.streetNumber != null) {
            postalAddress = postalAddress + this.streetNumber + " ";
        }
        if (this.streetName != null) {
            postalAddress = postalAddress + this.streetName + ", ";
        }
        if (this.district != null) {
            postalAddress = postalAddress + this.district + ", ";
        }
        if (this.city != null) {
            postalAddress = postalAddress + this.city + ", ";
        }
        if (this.area != null) {
            postalAddress = postalAddress + this.area + ", ";
        }
        if (this.country != null) {
            postalAddress = postalAddress + this.country;
        }
        return postalAddress;
    }

    public Map<String, String> getAddressProperties() {
        HashMap<String, String> addressProperties = new HashMap<String, String>();
        addressProperties.put(BUILDING_NAME_PROPERTY, this.buildingName);
        addressProperties.put(STREET_NUMBER_PROPERTY, this.streetNumber);
        addressProperties.put(STREET_NAME_PROPERTY, this.streetName);
        addressProperties.put(DISTRICT_NAME_PROPERTY, this.district);
        addressProperties.put(CITY_NAME_PROPERTY, this.city);
        addressProperties.put(AREA_NAME_PROPERTY, this.area);
        addressProperties.put(COUNTRY_NAME_PROPERTY, this.country);
        return addressProperties;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return "WorkLocation{" + this.displayName + "}";
    }
}

