/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.sustainability;

import java.util.Date;
import java.util.HashMap;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommunityMembershipType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.samples.archiveutilities.EgeriaBaseArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CocoGovernanceProgramArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.organization.CocoOrganizationArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.organization.ScopeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.FacilityDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.FacilityTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.GlossaryCategoryDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.GlossaryTermDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.GovernanceDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.GovernanceDefinitionLink;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.SustainabilityDomainDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.SustainabilityRoleDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.SustainabilitySubjectAreaDefinition;

public class CocoSustainabilityArchiveWriter
extends EgeriaBaseArchiveWriter {
    private static final String archiveFileName = "CocoSustainabilityArchive.omarchive";
    private static final String sustainabilitySubjectArea = "SubjectArea:Sustainability";
    private static final String archiveGUID = "be351568-97ec-4c34-bca5-aff93f326d9e";
    private static final String archiveName = "Coco Pharmaceuticals Sustainability Project";
    private static final String archiveDescription = "The base definitions for Coco Pharmaceuticals' sustainability initiative.";
    private static final Date creationDate = new Date(1639984840038L);

    public CocoSustainabilityArchiveWriter() {
        super(archiveGUID, archiveName, archiveDescription, creationDate, archiveFileName, new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive(), new CocoOrganizationArchiveWriter().getOpenMetadataArchive(), new CocoGovernanceProgramArchiveWriter().getOpenMetadataArchive()});
    }

    public void getArchiveContent() {
        this.writeDomains();
        this.writeSubjectAreaDefinitions();
        this.writeFacilityTypeValidValueSet();
        this.writeGlossary();
        this.writeGovernanceDefinitions();
        this.writeRoles();
        this.writeFacility();
    }

    private void writeFacilityTypeValidValueSet() {
        String validValueSetQName = OpenMetadataType.VALID_VALUE_SET.typeName + "::FacilityType";
        String validValueSetGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_SET.typeName, validValueSetQName, "FacilityType", "Describes the type of facility at a physical location.", "Used to tag Location entities to show the likely equipment that needs cataloging and managing.", "Used for physical types of Locations.", null, false, null);
        if (validValueSetGUID != null) {
            this.archiveHelper.addSubjectAreaClassification(validValueSetGUID, sustainabilitySubjectArea);
            for (FacilityTypeDefinition facilityTypeDefinition : FacilityTypeDefinition.values()) {
                String validValueGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_DEFINITION.typeName, facilityTypeDefinition.getQualifiedName(), facilityTypeDefinition.getDisplayName(), facilityTypeDefinition.getDescription(), "Used to tag Location entities to show the likely equipment that needs cataloging and managing.", "Used for physical types of Locations.", facilityTypeDefinition.getPreferredValue(), false, null);
                if (validValueGUID == null) continue;
                this.archiveHelper.addValidValueMembershipRelationship(validValueSetQName, facilityTypeDefinition.getQualifiedName(), false);
            }
        }
    }

    private void writeSubjectAreaDefinitions() {
        HashMap<String, String> subjectAreaMap = new HashMap<String, String>();
        for (SustainabilitySubjectAreaDefinition subjectAreaDefinition : SustainabilitySubjectAreaDefinition.values()) {
            String subjectAreaGUID = this.archiveHelper.addSubjectAreaDefinition(subjectAreaDefinition.getQualifiedName(), subjectAreaDefinition.getSubjectAreaName(), subjectAreaDefinition.getDisplayName(), subjectAreaDefinition.getDescription(), subjectAreaDefinition.getScope(), subjectAreaDefinition.getUsage(), subjectAreaDefinition.getDomain(), null, null);
            subjectAreaMap.put(subjectAreaDefinition.getSubjectAreaName(), subjectAreaGUID);
            if (subjectAreaDefinition.getParent() == null) continue;
            String subjectAreaParentGUID = this.archiveHelper.queryGUID(subjectAreaDefinition.getParent().getQualifiedName());
            this.archiveHelper.addSubjectAreaHierarchy(subjectAreaParentGUID, subjectAreaGUID);
        }
    }

    private void writeGovernanceDefinitions() {
        for (GovernanceDefinition governanceDefinition : GovernanceDefinition.values()) {
            this.archiveHelper.setGUID(governanceDefinition.getQualifiedName(), governanceDefinition.getGUID());
            String governanceDefinitionGUID = this.archiveHelper.addGovernanceDefinition(governanceDefinition.getType(), governanceDefinition.getQualifiedName(), governanceDefinition.getTitle(), governanceDefinition.getSummary(), governanceDefinition.getDescription(), governanceDefinition.getScope().getPreferredValue(), governanceDefinition.getDomain(), governanceDefinition.getImportance(), governanceDefinition.getImplications(), governanceDefinition.getOutcomes(), governanceDefinition.getResults(), null, null);
            assert (governanceDefinition.getGUID().equals(governanceDefinitionGUID));
        }
        for (Enum enum_ : GovernanceDefinitionLink.values()) {
            this.archiveHelper.addGovernanceDefinitionDelegationRelationship(((GovernanceDefinitionLink)enum_).getRelationshipType(), ((GovernanceDefinitionLink)enum_).getParentDefinition().getQualifiedName(), ((GovernanceDefinitionLink)enum_).getChildDefinition().getQualifiedName(), null);
        }
    }

    private void writeRoles() {
        String communityQName = "Community: " + SustainabilityDomainDefinition.SUSTAINABILITY_REPORTING.getQualifiedName();
        for (SustainabilityRoleDefinition roleDefinition : SustainabilityRoleDefinition.values()) {
            this.archiveHelper.addGovernanceRole(roleDefinition.getTypeName(), roleDefinition.getQualifiedName(), SustainabilityDomainDefinition.SUSTAINABILITY_REPORTING.getDomainIdentifier(), roleDefinition.getIdentifier(), roleDefinition.getDisplayName(), roleDefinition.getDescription(), roleDefinition.getScope().getPreferredValue(), roleDefinition.isHeadCountSet(), roleDefinition.getHeadCount(), null, null);
            this.archiveHelper.addCommunityMembershipRelationship(communityQName, roleDefinition.getQualifiedName(), CommunityMembershipType.CONTRIBUTOR.getOrdinal());
            if (roleDefinition.getBusinessArea() != null) {
                this.archiveHelper.addAssignmentScopeRelationship(roleDefinition.getQualifiedName(), roleDefinition.getBusinessArea().getQualifiedName(), null, null);
            }
            if (roleDefinition.getAppointee() != null) {
                this.archiveHelper.addPersonRoleAppointmentRelationship(roleDefinition.getAppointee().getQualifiedName(), roleDefinition.getQualifiedName(), true);
            }
            if (roleDefinition.getGovernanceResponsibility() == null) continue;
            this.archiveHelper.addGovernanceResponsibilityAssignmentRelationship(roleDefinition.getQualifiedName(), roleDefinition.getGovernanceResponsibility().getQualifiedName());
        }
    }

    private void writeDomains() {
        String governanceDomainSetGUID = this.getParentSet(null, null, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, null);
        for (SustainabilityDomainDefinition domainDefinition : SustainabilityDomainDefinition.values()) {
            this.archiveHelper.addValidValue(null, governanceDomainSetGUID, governanceDomainSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, OpenMetadataType.VALID_VALUE_SET.typeName, domainDefinition.getQualifiedName(), domainDefinition.getDisplayName(), domainDefinition.getDescription(), domainDefinition.getCategory(), "Used to control valid values in open metadata.", DataType.INT.getName(), "Open Metadata Ecosystem", Integer.toString(domainDefinition.getDomainIdentifier()), false, false, null);
            String communityQName = "Community: " + domainDefinition.getQualifiedName();
            this.archiveHelper.addCommunity(null, communityQName, domainDefinition.getCommunityName(), "Community supporting " + domainDefinition.getDisplayName() + " that is lead by the governance domain leader and includes all the people supporting the domain.", "To provide a mechanism for communication and coordination of work across Coco Pharmaceuticals that supports this governance domain.", null, null);
            this.archiveHelper.addResourceListRelationship(domainDefinition.getQualifiedName(), communityQName, ResourceUse.SUPPORTING_PEOPLE.getResourceUse(), null);
            String governanceOfficerQName = OpenMetadataType.GOVERNANCE_OFFICER.typeName + ": " + domainDefinition.getQualifiedName();
            this.archiveHelper.addGovernanceRole(OpenMetadataType.GOVERNANCE_OFFICER.typeName, governanceOfficerQName, domainDefinition.getDomainIdentifier(), "GOV_OFFICER:" + domainDefinition.getDomainIdentifier(), "Governance Officer for " + domainDefinition.getDisplayName(), null, null, true, 1, null, null);
            if (domainDefinition.getGovernanceOfficer() == null) continue;
            this.archiveHelper.addPersonRoleAppointmentRelationship(domainDefinition.getGovernanceOfficer().getQualifiedName(), governanceOfficerQName, true);
        }
    }

    private void writeGlossary() {
        String glossaryGUID = this.archiveHelper.addGlossary("Glossary:Sustainability", "Sustainability Glossary", "Terminology associated with Coco Pharmaceutical's sustainability initiative.", "English", "For all Coco Pharmaceutical employees wishing to understand more about sustainability and the organization's efforts to improve its operations.", null, ScopeDefinition.ALL_COCO.getPreferredValue());
        this.archiveHelper.addSubjectAreaClassification(glossaryGUID, sustainabilitySubjectArea);
        HashMap<String, String> categoryLookup = new HashMap<String, String>();
        for (GlossaryCategoryDefinition glossaryCategoryDefinition : GlossaryCategoryDefinition.values()) {
            String glossaryCategoryGUID = this.archiveHelper.addGlossaryCategory(glossaryGUID, glossaryCategoryDefinition.getQualifiedName(), glossaryCategoryDefinition.getName(), glossaryCategoryDefinition.getDescription(), null);
            categoryLookup.put(glossaryCategoryDefinition.getName(), glossaryCategoryGUID);
        }
        for (Enum enum_ : GlossaryTermDefinition.values()) {
            String glossaryTermGUID = this.archiveHelper.addTerm(glossaryGUID, null, false, "GlossaryTerm:" + ((GlossaryTermDefinition)enum_).getName(), ((GlossaryTermDefinition)enum_).getName(), ((GlossaryTermDefinition)enum_).getSummary(), ((GlossaryTermDefinition)enum_).getDescription(), null, ((GlossaryTermDefinition)enum_).getAbbreviation(), null, false, false, false, null, null, null, null);
            if (((GlossaryTermDefinition)enum_).getCategory() != null) {
                this.archiveHelper.addTermToCategory((String)categoryLookup.get(((GlossaryTermDefinition)enum_).getCategory().getName()), glossaryTermGUID);
            }
            if (((GlossaryTermDefinition)enum_).getUrl() == null) continue;
            this.archiveHelper.addExternalReference(null, glossaryTermGUID, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.GLOSSARY_TERM.typeName, glossaryGUID, "ExternalReference:" + ((GlossaryTermDefinition)enum_).getName(), null, null, null, null, null, 0, null, null, null, null, null, null, ((GlossaryTermDefinition)enum_).getUrl(), null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }

    private void writeFacility() {
        for (FacilityDefinition facilityDefinition : FacilityDefinition.values()) {
            String locationGUID;
            if (facilityDefinition.getAssociatedWorkLocation() != null) {
                locationGUID = this.archiveHelper.addFixedLocation(facilityDefinition.getQualifiedName(), facilityDefinition.getIdentifier(), facilityDefinition.getDisplayName(), facilityDefinition.getDescription(), null, null, facilityDefinition.getAssociatedWorkLocation().getPostalAddress(), facilityDefinition.getAssociatedWorkLocation().getTimeZone(), null);
                String validValueGUID = this.archiveHelper.getGUID("OpenMetadata.ValidValueSet." + facilityDefinition.getAssociatedWorkLocation().getQualifiedName());
                this.archiveHelper.addMoreInformationLink(validValueGUID, locationGUID);
            } else {
                locationGUID = this.archiveHelper.addFixedLocation(facilityDefinition.getQualifiedName(), facilityDefinition.getIdentifier(), facilityDefinition.getDisplayName(), facilityDefinition.getDescription(), null, null, null, null, null);
            }
            if (facilityDefinition.getParentSite() != null) {
                String parentGUID = this.archiveHelper.getGUID(facilityDefinition.getParentSite().getQualifiedName());
                this.archiveHelper.addLocationHierarchy(parentGUID, locationGUID);
            }
            if (facilityDefinition.getFacilityType() != null) {
                this.archiveHelper.addReferenceValueAssignmentRelationship(facilityDefinition.getQualifiedName(), facilityDefinition.getFacilityType().getQualifiedName(), 100, null, null, null, null);
            }
            if (facilityDefinition.getFacilityLeaderRole() == null) continue;
            this.archiveHelper.addAssignmentScopeRelationship(facilityDefinition.getFacilityLeaderRole().getQualifiedName(), facilityDefinition.getQualifiedName(), null, null);
            if (facilityDefinition.getFacilityLeader() == null) continue;
            this.archiveHelper.addPersonRoleAppointmentRelationship(facilityDefinition.getFacilityLeader().getQualifiedName(), facilityDefinition.getFacilityLeaderRole().getQualifiedName(), true);
        }
    }
}

