/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.sustainability;

public enum FacilityTypeDefinition {
    SITE("Site", "Primary Site", "Primary location containing multiple facilities within it.", "These are the organization's primary sites."),
    LAB("Lab", "Research Laboratory", "Location where product research is conducted involving chemical and sample storage, experiments, candidate product creation/testing.", "Identify locations with lab facilities.  Do not include locations that focus on the analysis and office work associated with product development."),
    OFFICE("Office", "Office", "Location where staff work at desks with computer equipment.", "Identify locations where the primary focus is office workers."),
    FACTORY("Factory", "Manufacturing Facility", "Location where products are manufactured from supplied chemicals.", "Identify locations with manufacturing facilities.  Do not include locations that are able to create test batches as part of product development."),
    DEPOT("Depot", "Warehouse and Distribution Depot", "Location where product research is conducted involving chemical and sample storage, experiments, data capture and data science.", "Identify locations with lab facilities.  Do not include locations that focus on the analysis and office work associated with product development."),
    DATA_CENTER("Data centre", "Data centre/center", "Location where shared computing resource is housed and managed from.", "Identify locations with shared computer facilities.  Do not include locations where individuals are using their laptops and other machines allocated to them personally."),
    CLOUD("External cloud service", "Cloud provider", "Digital location provided by an external cloud vendor.", "Identify digital services and systems not managed by Coco Pharmaceuticals.");

    public static final String validValueSetName = "FacilityType";
    public static final String validValueSetDescription = "Describes the type of facility at a physical location.";
    public static final String validValueSetUsage = "Used to tag Location entities to show the likely equipment that needs cataloging and managing.";
    public static final String validValueSetScope = "Used for physical types of Locations.";
    private final String preferredValue;
    private final String displayName;
    private final String description;
    private final String usage;

    private FacilityTypeDefinition(String preferredValue, String displayName, String description, String usage) {
        this.preferredValue = preferredValue;
        this.displayName = displayName;
        this.description = description;
        this.usage = usage;
    }

    public String getQualifiedName() {
        return "FacilityType." + this.preferredValue;
    }

    public String getPreferredValue() {
        return this.preferredValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public String toString() {
        return "FacilityTypeDefinition{" + this.displayName + "}";
    }
}

