/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.sustainability;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;

public enum SustainabilityDomainDefinition {
    SUSTAINABILITY_REPORTING(9, "Sustainability", "Initiatives to improve the operational sustainability of Coco Pharmaceuticals.  This includes sustainability reports to employees and the regulators, along with education for employees and initiatives to reduce the emission of greenhouse gases.", "Sustainability Community", PersonDefinition.TOM_TALLY);

    private final int domainIdentifier;
    private final String displayName;
    private final String description;
    private final String communityName;
    private final PersonDefinition governanceOfficer;

    private SustainabilityDomainDefinition(int domainIdentifier, String displayName, String description, String communityName, PersonDefinition governanceOfficer) {
        this.domainIdentifier = domainIdentifier;
        this.displayName = displayName;
        this.description = description;
        this.communityName = communityName;
        this.governanceOfficer = governanceOfficer;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, (String)OpenMetadataProperty.DOMAIN_IDENTIFIER.name, null, (String)Integer.toString(this.domainIdentifier));
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, (String)OpenMetadataProperty.DOMAIN_IDENTIFIER.name, null);
    }

    public int getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCommunityName() {
        return this.communityName;
    }

    public PersonDefinition getGovernanceOfficer() {
        return this.governanceOfficer;
    }

    public String toString() {
        return "GovernanceDomain{" + this.displayName + "}";
    }
}

