/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.collectionmanager.server;

import org.odpi.openmetadata.accessservices.digitalservice.client.CollectionsClient;
import org.odpi.openmetadata.accessservices.digitalservice.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.digitalservice.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class CollectionManagerInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.COLLECTION_MANAGER;
    private final CollectionsClient collectionsClient;
    private final ConnectedAssetClient connectedAssetClient;
    private final OpenMetadataStoreClient openMetadataStoreClient;

    public CollectionManagerInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.collectionsClient = new CollectionsClient(remoteServerName, remoteServerURL, maxPageSize);
        this.connectedAssetClient = new ConnectedAssetClient(remoteServerName, remoteServerURL, auditLog);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(remoteServerName, remoteServerURL, maxPageSize);
    }

    public CollectionsClient getCollectionsClient() {
        return this.collectionsClient;
    }

    public ConnectedAssetClient getConnectedAssetClient() {
        return this.connectedAssetClient;
    }

    public OpenMetadataStoreClient getOpenMetadataStoreClient() {
        return this.openMetadataStoreClient;
    }
}

