/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.collectionmanager.server;

import org.odpi.openmetadata.accessservices.digitalservice.client.CollectionsClient;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionMembersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewCollectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewDigitalProductRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.digitalbusiness.DigitalProductProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.resources.ResourceListProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.collectionmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.viewservices.collectionmanager.server.CollectionManagerInstanceHandler;
import org.slf4j.LoggerFactory;

public class CollectionManagerRESTServices
extends TokenController {
    private static final CollectionManagerInstanceHandler instanceHandler = new CollectionManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(CollectionManagerRESTServices.class), instanceHandler.getServiceName());

    public CollectionsResponse getAttachedCollections(String serverName, String parentGUID, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getAttachedCollections";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getAttachedCollections");
        CollectionsResponse response = new CollectionsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getAttachedCollections");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttachedCollections");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "getAttachedCollections");
            if (requestBody != null) {
                response.setElements(handler.getAttachedCollections(userId, parentGUID, requestBody.getFilter(), startFrom, pageSize));
            } else {
                response.setElements(handler.getAttachedCollections(userId, parentGUID, null, startFrom, pageSize));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttachedCollections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionsResponse getClassifiedCollections(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getClassifiedCollections";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getClassifiedCollections");
        CollectionsResponse response = new CollectionsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getClassifiedCollections");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getClassifiedCollections");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "getClassifiedCollections");
            if (requestBody != null) {
                response.setElements(handler.getClassifiedCollections(userId, requestBody.getFilter(), startFrom, pageSize));
            } else {
                response.setElements(handler.getClassifiedCollections(userId, null, startFrom, pageSize));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getClassifiedCollections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionsResponse findCollections(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findCollections";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findCollections");
        CollectionsResponse response = new CollectionsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findCollections");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findCollections");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "findCollections");
            if (requestBody != null) {
                response.setElements(handler.findCollections(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElements(handler.findCollections(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), startFrom, pageSize, null));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findCollections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionsResponse getCollectionsByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getCollectionsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCollectionsByName");
        CollectionsResponse response = new CollectionsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCollectionsByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCollectionsByName");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "getCollectionsByName");
            response.setElements(handler.getCollectionsByName(userId, requestBody.getFilter(), startFrom, pageSize, requestBody.getEffectiveTime()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCollectionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionsResponse getCollectionsByType(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getCollectionsByType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCollectionsByType");
        CollectionsResponse response = new CollectionsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCollectionsByType");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCollectionsByType");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "getCollectionsByType");
            if (requestBody != null) {
                response.setElements(handler.getCollectionsByType(userId, requestBody.getFilter(), startFrom, pageSize));
            } else {
                response.setElements(handler.getCollectionsByType(userId, null, startFrom, pageSize));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCollectionsByType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionResponse getCollection(String serverName, String collectionGUID) {
        String methodName = "getCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCollection");
        CollectionResponse response = new CollectionResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCollection");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "getCollection");
            response.setElement(handler.getCollection(userId, collectionGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createCollection(String serverName, String optionalClassificationName, NewCollectionRequestBody requestBody) {
        String methodName = "createCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createCollection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createCollection");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "createCollection");
                response.setGUID(handler.createCollection(userId, requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), optionalClassificationName, requestBody.getCollectionProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createRootCollection(String serverName, NewCollectionRequestBody requestBody) {
        String methodName = "createRootCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createRootCollection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createRootCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createRootCollection");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "createRootCollection");
                response.setGUID(handler.createCollection(userId, requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), OpenMetadataType.ROOT_COLLECTION.typeName, requestBody.getCollectionProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createRootCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createRootCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataSpecCollection(String serverName, NewCollectionRequestBody requestBody) {
        String methodName = "createDataSpecCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createDataSpecCollection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createDataSpecCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataSpecCollection");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "createDataSpecCollection");
                response.setGUID(handler.createCollection(userId, requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), OpenMetadataType.DATA_SPEC_COLLECTION.typeName, requestBody.getCollectionProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createDataSpecCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDataSpecCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createFolderCollection(String serverName, NewCollectionRequestBody requestBody) {
        String methodName = "createFolderCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createFolderCollection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createFolderCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderCollection");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "createFolderCollection");
                response.setGUID(handler.createCollection(userId, requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), OpenMetadataType.FOLDER.typeName, requestBody.getCollectionProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createFolderCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createFolderCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createCollectionFromTemplate(String serverName, TemplateRequestBody requestBody) {
        String methodName = "createCollectionFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createCollectionFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createCollectionFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createCollectionFromTemplate");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "createCollectionFromTemplate");
                response.setGUID(handler.createCollectionFromTemplate(userId, requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), null, null, requestBody.getTemplateGUID(), requestBody.getReplacementProperties(), requestBody.getPlaceholderPropertyValues(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createCollectionFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createCollectionFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDigitalProduct(String serverName, NewDigitalProductRequestBody requestBody) {
        String methodName = "createDigitalProduct";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createDigitalProduct");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createDigitalProduct");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDigitalProduct");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "createDigitalProduct");
                response.setGUID(handler.createDigitalProduct(userId, requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getCollectionProperties(), requestBody.getDigitalProductProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createDigitalProduct", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDigitalProduct", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCollection(String serverName, String collectionGUID, boolean replaceAllProperties, CollectionProperties requestBody) {
        String methodName = "updateCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateCollection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCollection");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "updateCollection");
                handler.updateCollection(userId, collectionGUID, replaceAllProperties, requestBody);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDigitalProduct(String serverName, String collectionGUID, boolean replaceAllProperties, DigitalProductProperties requestBody) {
        String methodName = "updateDigitalProduct";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateDigitalProduct");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateDigitalProduct");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDigitalProduct");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "updateDigitalProduct");
                handler.updateDigitalProduct(userId, collectionGUID, replaceAllProperties, requestBody);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateDigitalProduct", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDigitalProduct", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachCollection(String serverName, String collectionGUID, String parentGUID, boolean makeAnchor, ResourceListProperties requestBody) {
        String methodName = "attachCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "attachCollection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "attachCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachCollection");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "attachCollection");
                handler.attachCollection(userId, collectionGUID, parentGUID, requestBody, makeAnchor);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "attachCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "attachCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachCollection(String serverName, String collectionGUID, String parentGUID, NullRequestBody requestBody) {
        String methodName = "detachCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "detachCollection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "detachCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachCollection");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "detachCollection");
            handler.detachCollection(userId, collectionGUID, parentGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "detachCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteCollection(String serverName, String collectionGUID, NullRequestBody requestBody) {
        String methodName = "deleteCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteCollection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteCollection");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "deleteCollection");
            handler.deleteCollection(userId, collectionGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionMembersResponse getCollectionMembers(String serverName, String collectionGUID, int startFrom, int pageSize) {
        String methodName = "getCollectionMembers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCollectionMembers");
        CollectionMembersResponse response = new CollectionMembersResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCollectionMembers");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCollectionMembers");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "getCollectionMembers");
            response.setElements(handler.getCollectionMembers(userId, collectionGUID, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCollectionMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addToCollection(String serverName, String collectionGUID, String elementGUID, CollectionMembershipProperties requestBody) {
        String methodName = "addToCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addToCollection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addToCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addToCollection");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "addToCollection");
                handler.addToCollection(userId, collectionGUID, requestBody, elementGUID);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addToCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addToCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCollectionMembership(String serverName, String collectionGUID, String elementGUID, boolean replaceAllProperties, CollectionMembershipProperties requestBody) {
        String methodName = "updateCollectionMembership";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateCollectionMembership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateCollectionMembership");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCollectionMembership");
            if (requestBody != null) {
                CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "updateCollectionMembership");
                handler.updateCollectionMembership(userId, collectionGUID, replaceAllProperties, requestBody, elementGUID);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateCollectionMembership", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCollectionMembership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeFromCollection(String serverName, String collectionGUID, String elementGUID, NullRequestBody requestBody) {
        String methodName = "removeFromCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeFromCollection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeFromCollection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeFromCollection");
            CollectionsClient handler = instanceHandler.getCollectionsClient(userId, serverName, "removeFromCollection");
            handler.removeFromCollection(userId, collectionGUID, elementGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeFromCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

