/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.collectionmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionMembersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewCollectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewDigitalProductRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.digitalbusiness.DigitalProductProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.resources.ResourceListProperties;
import org.odpi.openmetadata.viewservices.collectionmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.viewservices.collectionmanager.server.CollectionManagerRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/collection-manager"})
@Tag(name="API: Collection Manager OMVS", description="Maintain and explore the contents of nested collections. These collections can be used to represent digital products, or collections of resources for a particular project or team. They can be used to organize assets and other resources into logical groups.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/collection-manager/overview/"))
public class CollectionManagerResource {
    private final CollectionManagerRESTServices restAPI = new CollectionManagerRESTServices();

    @PostMapping(path={"/metadata-elements/{parentGUID}/collections"})
    @Operation(summary="getAttachedCollections", description="Returns the list of collections that are linked off of the supplied element using the ResourceList relationship.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public CollectionsResponse getAttachedCollections(@PathVariable String serverName, @PathVariable String parentGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getAttachedCollections(serverName, parentGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/collections/by-classifications"})
    @Operation(summary="getClassifiedCollections", description="Returns the list of collections with a particular classification.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public CollectionsResponse getClassifiedCollections(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getClassifiedCollections(serverName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/collections/by-search-string"})
    @Operation(summary="findCollections", description="Returns the list of collections matching the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public CollectionsResponse findCollections(@PathVariable String serverName, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findCollections(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/collections/by-name"})
    @Operation(summary="getCollectionsByName", description="Returns the list of collections with a particular name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public CollectionsResponse getCollectionsByName(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getCollectionsByName(serverName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/collections/by-collection-type"})
    @Operation(summary="getCollectionsByType", description="Returns the list of collections with a particular collectionType.  This is an optional text field in the collection element.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public CollectionsResponse getCollectionsByType(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getCollectionsByType(serverName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/collections/{collectionGUID}"})
    @Operation(summary="getCollection", description="Return the properties of a specific collection.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public CollectionResponse getCollection(@PathVariable String serverName, @PathVariable String collectionGUID) {
        return this.restAPI.getCollection(serverName, collectionGUID);
    }

    @PostMapping(path={"/collections"})
    @Operation(summary="createCollection", description="Create a new generic collection.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public GUIDResponse createCollection(@PathVariable String serverName, @RequestParam(required=false) String classificationName, @RequestBody NewCollectionRequestBody requestBody) {
        return this.restAPI.createCollection(serverName, classificationName, requestBody);
    }

    @PostMapping(path={"/collections/root-collection"})
    @Operation(summary="createRootCollection", description="Create a new collection with the RootCollection classification.  Used to identify the top of a collection hierarchy.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public GUIDResponse createRootCollection(@PathVariable String serverName, @RequestBody NewCollectionRequestBody requestBody) {
        return this.restAPI.createRootCollection(serverName, requestBody);
    }

    @PostMapping(path={"/collections/data-spec-collection"})
    @Operation(summary="createDataSpecCollection", description="Create a new collection with the DataSpec classification.  Used to identify a collection of data fields and schema types.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public GUIDResponse createDataSpecCollection(@PathVariable String serverName, @RequestBody NewCollectionRequestBody requestBody) {
        return this.restAPI.createDataSpecCollection(serverName, requestBody);
    }

    @PostMapping(path={"/collections/folder"})
    @Operation(summary="createFolderCollection", description="Create a new collection with the Folder classification.  This is used to identify the organizing collections in a collection hierarchy.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public GUIDResponse createFolderCollection(@PathVariable String serverName, @RequestBody NewCollectionRequestBody requestBody) {
        return this.restAPI.createFolderCollection(serverName, requestBody);
    }

    @PostMapping(path={"/collections/from-template"})
    @Operation(summary="createCollectionFromTemplate", description="Create a new metadata element to represent a collection using an existing metadata element as a template. The template defines additional classifications and relationships that should be added to the new collection.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public GUIDResponse createCollectionFromTemplate(@PathVariable String serverName, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createCollectionFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/digital-products"})
    @Operation(summary="createDigitalProduct", description="Create a new collection that represents a digital product.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/digital-product"))
    public GUIDResponse createDigitalProduct(@PathVariable String serverName, @RequestBody NewDigitalProductRequestBody requestBody) {
        return this.restAPI.createDigitalProduct(serverName, requestBody);
    }

    @PostMapping(path={"/collections/{collectionGUID}/update"})
    @Operation(summary="updateCollection", description="Update the properties of a collection.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public VoidResponse updateCollection(@PathVariable String serverName, @PathVariable String collectionGUID, @RequestParam boolean replaceAllProperties, @RequestBody CollectionProperties requestBody) {
        return this.restAPI.updateCollection(serverName, collectionGUID, replaceAllProperties, requestBody);
    }

    @PostMapping(path={"/digital-products/{collectionGUID}/update"})
    @Operation(summary="updateDigitalProduct", description="Update the properties of the DigitalProduct classification attached to a collection.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/digital-product"))
    public VoidResponse updateDigitalProduct(@PathVariable String serverName, @PathVariable String collectionGUID, @RequestParam boolean replaceAllProperties, @RequestBody DigitalProductProperties requestBody) {
        return this.restAPI.updateDigitalProduct(serverName, collectionGUID, replaceAllProperties, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{parentGUID}/collections/{collectionGUID}/attach"})
    @Operation(summary="attachCollection", description="Connect an existing collection to an element using the ResourceList relationship (0019).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public VoidResponse attachCollection(@PathVariable String serverName, @PathVariable String collectionGUID, @PathVariable String parentGUID, @RequestParam boolean makeAnchor, @RequestBody ResourceListProperties requestBody) {
        return this.restAPI.attachCollection(serverName, collectionGUID, parentGUID, makeAnchor, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{parentGUID}/collections/{collectionGUID}/detach"})
    @Operation(summary="detachCollection", description="Detach an existing collection from an element.  If the collection is anchored to the element, it is deleted.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public VoidResponse detachCollection(@PathVariable String serverName, @PathVariable String collectionGUID, @PathVariable String parentGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.detachCollection(serverName, collectionGUID, parentGUID, requestBody);
    }

    @PostMapping(path={"/collections/{collectionGUID}/delete"})
    @Operation(summary="deleteCollection", description="Delete a collection.  It is detected from all parent elements.  If members are anchored to the collection then they are also deleted.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public VoidResponse deleteCollection(@PathVariable String serverName, @PathVariable String collectionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteCollection(serverName, collectionGUID, requestBody);
    }

    @GetMapping(path={"/collections/{collectionGUID}/members"})
    @Operation(summary="getCollectionMembers", description="Return a list of elements that are a member of a collection.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public CollectionMembersResponse getCollectionMembers(@PathVariable String serverName, @PathVariable String collectionGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize) {
        return this.restAPI.getCollectionMembers(serverName, collectionGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/collections/{collectionGUID}/members/{elementGUID}/attach"})
    @Operation(summary="addToCollection", description="Add an element to a collection.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public VoidResponse addToCollection(@PathVariable String serverName, @PathVariable String collectionGUID, @PathVariable String elementGUID, @RequestBody(required=false) CollectionMembershipProperties requestBody) {
        return this.restAPI.addToCollection(serverName, collectionGUID, elementGUID, requestBody);
    }

    @PostMapping(path={"/collections/{collectionGUID}/members/{elementGUID}/update"})
    @Operation(summary="updateCollectionMembership", description="Update an element's membership to a collection.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public VoidResponse updateCollectionMembership(@PathVariable String serverName, @PathVariable String collectionGUID, @PathVariable String elementGUID, @RequestParam boolean replaceAllProperties, @RequestBody CollectionMembershipProperties requestBody) {
        return this.restAPI.updateCollectionMembership(serverName, collectionGUID, elementGUID, replaceAllProperties, requestBody);
    }

    @PostMapping(path={"/collections/{collectionGUID}/members/{elementGUID}/detach"})
    @Operation(summary="removeFromCollection", description="Remove an element from a collection.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/collection"))
    public VoidResponse removeFromCollection(@PathVariable String serverName, @PathVariable String collectionGUID, @PathVariable String elementGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeFromCollection(serverName, collectionGUID, elementGUID, requestBody);
    }
}

