/* SPDX-License-Identifier: Apache 2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.accessservices.communityprofile;

/**
 * The Community Profile Open Metadata Access Service (OMAS) is used by tools and administrators to
 * maintain information associated with individuals and communities. The client interfaces are targeted
 * at different use cases.  They are as follows:
 *
 * <ul>
 *     <li>MyProfileManagement covers the management of a personal profile by the userId
 *     associated with the profile.</li>
 *
 *     <li>MyNotificationsInterface covers the management of personal notifications that derive from changes
 *     to the metadata.</li>
 *
 *     <li>PersonalProfileManagementInterface covers the setting up and removal of personal profiles by an administrator.</li>
 *
 *     <li>CollectionManagement covers the management of collections of resources that can be attached to
 *     personal profiles, projects or communities.</li>
 *
 *     <li>CommunityManagementInterface covers the administrator's role in setting up and shutting down communities.</li>
 * </ul>
 */