/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommentHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommentType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Comment
extends CommentHeader {
    private CommentType commentType = null;
    private List<String> answeredBy = null;
    private List<String> answers = null;

    public Comment() {
    }

    public Comment(Comment template) {
        super(template);
        if (template != null) {
            this.commentType = template.getCommentType();
            this.answeredBy = template.getAnsweredBy();
            this.answers = template.getAnswers();
        }
    }

    public CommentType getCommentType() {
        return this.commentType;
    }

    public void setCommentType(CommentType commentType) {
        this.commentType = commentType;
    }

    public List<String> getAnsweredBy() {
        return this.answeredBy;
    }

    public void setAnsweredBy(List<String> answeredBy) {
        this.answeredBy = answeredBy;
    }

    public List<String> getAnswers() {
        return this.answers;
    }

    public void setAnswers(List<String> answers) {
        this.answers = answers;
    }

    @Override
    public String toString() {
        return "Comment{commentType=" + this.commentType + ", answeredBy=" + this.answeredBy + ", answers=" + this.answers + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", text='" + this.getText() + '\'' + ", commentProperties=" + this.getExtendedProperties() + ", additionalProperties=" + this.getAdditionalProperties() + ", userId='" + this.getUserId() + '\'' + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Comment comment = (Comment)objectToCompare;
        return this.getCommentType() == comment.getCommentType() && Objects.equals(this.getAnsweredBy(), comment.getAnsweredBy()) && Objects.equals(this.getAnswers(), comment.getAnswers());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCommentType(), this.getAnsweredBy(), this.getAnswers());
    }
}

