/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Classification;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContributionRecord
extends CommonHeader {
    private List<Classification> classifications = null;
    private String qualifiedName = null;
    private int karmaPoints = 0;
    private int karmaPointPlateau = 0;
    private Map<String, Object> extendedProperties = null;
    private Map<String, String> additionalProperties = null;

    public ContributionRecord() {
    }

    public ContributionRecord(ContributionRecord template) {
        super(template);
        if (template != null) {
            this.classifications = template.getClassifications();
            this.qualifiedName = template.getQualifiedName();
            this.karmaPoints = template.getKarmaPoints();
            this.karmaPointPlateau = template.getKarmaPointPlateau();
            this.extendedProperties = template.getExtendedProperties();
            this.additionalProperties = template.getAdditionalProperties();
        }
    }

    public List<Classification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return this.classifications;
    }

    public void setClassifications(List<Classification> classifications) {
        this.classifications = classifications;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public int getKarmaPoints() {
        return this.karmaPoints;
    }

    public void setKarmaPoints(int karmaPoints) {
        this.karmaPoints = karmaPoints;
    }

    public int getKarmaPointPlateau() {
        return this.karmaPointPlateau;
    }

    public void setKarmaPointPlateau(int karmaPointPlateau) {
        this.karmaPointPlateau = karmaPointPlateau;
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.extendedProperties == null) {
            return null;
        }
        if (this.extendedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.extendedProperties);
    }

    public void setExtendedProperties(Map<String, Object> additionalProperties) {
        this.extendedProperties = additionalProperties;
    }

    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.additionalProperties);
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Override
    public String toString() {
        return "PersonalProfile{classifications=" + this.classifications + ", qualifiedName='" + this.qualifiedName + '\'' + ", karmaPoints=" + this.karmaPoints + ", karmaPointPlateau=" + this.karmaPointPlateau + ", extendedProperties=" + this.extendedProperties + ", additionalProperties=" + this.additionalProperties + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + ", originId='" + this.getOriginId() + '\'' + ", originName='" + this.getOriginName() + '\'' + ", originType='" + this.getOriginType() + '\'' + ", originLicense='" + this.getOriginLicense() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ContributionRecord that = (ContributionRecord)objectToCompare;
        return this.getKarmaPoints() == that.getKarmaPoints() && this.getKarmaPointPlateau() == that.getKarmaPointPlateau() && Objects.equals(this.getClassifications(), that.getClassifications()) && Objects.equals(this.getExtendedProperties(), that.getExtendedProperties()) && Objects.equals(this.getAdditionalProperties(), that.getAdditionalProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getClassifications(), this.getKarmaPoints(), this.getKarmaPointPlateau(), this.getExtendedProperties(), this.getAdditionalProperties());
    }
}

