/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEventType;
import org.odpi.openmetadata.accessservices.communityprofile.events.PersonalProfileOutboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class FavouriteCollectionOutboundEvent
extends PersonalProfileOutboundEvent {
    private String userId = null;
    private String memberGUID = null;
    private String memberType = null;

    public FavouriteCollectionOutboundEvent() {
    }

    public FavouriteCollectionOutboundEvent(CommunityProfileOutboundEventType type, PersonalProfile bean, String userId, String memberGUID, String memberTypeName) {
        super.setEventType(type);
        super.setPersonalProfile(bean);
        this.setUserId(userId);
        this.setMemberGUID(memberGUID);
        this.setMemberType(memberTypeName);
    }

    public FavouriteCollectionOutboundEvent(FavouriteCollectionOutboundEvent template) {
        super(template);
        if (template != null) {
            this.userId = template.getUserId();
            this.memberGUID = template.getMemberGUID();
            this.memberType = template.getMemberType();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getMemberGUID() {
        return this.memberGUID;
    }

    public void setMemberGUID(String memberGUID) {
        this.memberGUID = memberGUID;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public void setMemberType(String memberTypeName) {
        this.memberType = memberTypeName;
    }

    @Override
    public String toString() {
        return "FavouriteCollectionOutboundEvent{userId='" + this.userId + '\'' + ", memberGUID='" + this.memberGUID + '\'' + ", memberType='" + this.memberType + '\'' + ", personalProfile=" + this.getPersonalProfile() + ", eventType=" + this.getEventType() + ", eventVersionId=" + this.getEventVersionId() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        FavouriteCollectionOutboundEvent that = (FavouriteCollectionOutboundEvent)objectToCompare;
        return Objects.equals(this.getUserId(), that.getUserId()) && Objects.equals(this.getMemberGUID(), that.getMemberGUID()) && Objects.equals(this.getMemberType(), that.getMemberType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getUserId(), this.getMemberGUID(), this.getMemberType());
    }
}

