/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethod;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.TeamSummary;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PersonalProfile.class, name="PersonalProfile"), @JsonSubTypes.Type(value=TeamSummary.class, name="TeamSummary")})
public abstract class ActorHeader
extends ReferenceableHeader {
    private List<ContactMethod> contactDetails = null;

    public ActorHeader() {
    }

    public ActorHeader(ActorHeader template) {
        super(template);
        if (template != null) {
            this.contactDetails = template.getContactDetails();
        }
    }

    public List<ContactMethod> getContactDetails() {
        if (this.contactDetails == null) {
            return null;
        }
        if (this.contactDetails.isEmpty()) {
            return null;
        }
        ArrayList<ContactMethod> returnList = new ArrayList<ContactMethod>();
        for (ContactMethod contactMethod : this.contactDetails) {
            returnList.add(new ContactMethod(contactMethod));
        }
        return returnList;
    }

    public void setContactDetails(List<ContactMethod> contactDetails) {
        this.contactDetails = contactDetails;
    }

    @Override
    public String toString() {
        return "ActorHeader{contactDetails=" + this.contactDetails + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", classifications=" + this.getClassifications() + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ActorHeader that = (ActorHeader)objectToCompare;
        return Objects.equals(this.getContactDetails(), that.getContactDetails());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getContactDetails());
    }
}

