/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.AssetCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommunityCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ProjectCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.WatchStatus;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AssetCollectionMember.class, name="AssetCollectionMember"), @JsonSubTypes.Type(value=ProjectCollectionMember.class, name="ProjectCollectionMember"), @JsonSubTypes.Type(value=CommunityCollectionMember.class, name="CommunityCollectionMember")})
public class CollectionMemberHeader
extends ReferenceableHeader {
    private Date dateAddedToCollection = null;
    private String membershipRationale = null;
    private WatchStatus watchStatus = null;

    public CollectionMemberHeader() {
    }

    public CollectionMemberHeader(CollectionMemberHeader template) {
        super(template);
        if (template != null) {
            this.dateAddedToCollection = template.getDateAddedToCollection();
            this.membershipRationale = template.getMembershipRationale();
            this.watchStatus = template.getWatchStatus();
        }
    }

    public Date getDateAddedToCollection() {
        if (this.dateAddedToCollection == null) {
            return null;
        }
        return new Date(this.dateAddedToCollection.getTime());
    }

    public void setDateAddedToCollection(Date dateAddedToCollection) {
        this.dateAddedToCollection = dateAddedToCollection;
    }

    public String getMembershipRationale() {
        return this.membershipRationale;
    }

    public void setMembershipRationale(String membershipRationale) {
        this.membershipRationale = membershipRationale;
    }

    public WatchStatus getWatchStatus() {
        return this.watchStatus;
    }

    public void setWatchStatus(WatchStatus watchStatus) {
        this.watchStatus = watchStatus;
    }

    @Override
    public String toString() {
        return "CollectionMemberHeader{dateAddedToCollection=" + this.dateAddedToCollection + ", membershipRationale='" + this.membershipRationale + '\'' + ", watchStatus=" + this.watchStatus + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", classifications=" + this.getClassifications() + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CollectionMemberHeader that = (CollectionMemberHeader)objectToCompare;
        return Objects.equals(this.getDateAddedToCollection(), that.getDateAddedToCollection()) && Objects.equals(this.getMembershipRationale(), that.getMembershipRationale()) && this.getWatchStatus() == that.getWatchStatus();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDateAddedToCollection(), this.getMembershipRationale(), this.getWatchStatus());
    }
}

