/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommunityForumContribution;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalNote;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CommunityForumContribution.class, name="CommunityForumContribution"), @JsonSubTypes.Type(value=PersonalNote.class, name="PersonalNote")})
public abstract class NoteEntryHeader
extends CommonHeader {
    private String qualifiedName = null;
    private String title = null;
    private String text = null;

    public NoteEntryHeader() {
    }

    public NoteEntryHeader(NoteEntryHeader template) {
        super(template);
        if (template != null) {
            this.qualifiedName = template.getQualifiedName();
            this.title = template.getTitle();
            this.text = template.getText();
        }
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return "NoteEntryHeader{qualifiedName='" + this.qualifiedName + '\'' + ", title='" + this.title + '\'' + ", text='" + this.text + '\'' + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + ", originId='" + this.getOriginId() + '\'' + ", originName='" + this.getOriginName() + '\'' + ", originType='" + this.getOriginType() + '\'' + ", originLicense='" + this.getOriginLicense() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        NoteEntryHeader that = (NoteEntryHeader)objectToCompare;
        return Objects.equals(this.getQualifiedName(), that.getQualifiedName()) && Objects.equals(this.getTitle(), that.getTitle()) && Objects.equals(this.getText(), that.getText());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getQualifiedName(), this.getTitle(), this.getText());
    }
}

