/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ActorHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserIdentity;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PersonalProfile
extends ActorHeader {
    private String fullName = null;
    private String jobTitle = null;
    private List<UserIdentity> associatedUserIds = null;
    private Map<String, Object> extendedProperties = null;
    private Map<String, String> additionalProperties = null;

    public PersonalProfile() {
    }

    public PersonalProfile(PersonalProfile template) {
        super(template);
        if (template != null) {
            this.fullName = template.getFullName();
            this.jobTitle = template.getJobTitle();
            this.associatedUserIds = template.getAssociatedUserIds();
            this.extendedProperties = template.getExtendedProperties();
            this.additionalProperties = template.getAdditionalProperties();
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public List<UserIdentity> getAssociatedUserIds() {
        if (this.associatedUserIds == null) {
            return null;
        }
        if (this.associatedUserIds.isEmpty()) {
            return null;
        }
        return new ArrayList<UserIdentity>(this.associatedUserIds);
    }

    public void setAssociatedUserIds(List<UserIdentity> associatedUserIds) {
        this.associatedUserIds = associatedUserIds;
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.extendedProperties == null) {
            return null;
        }
        if (this.extendedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.extendedProperties);
    }

    public void setExtendedProperties(Map<String, Object> additionalProperties) {
        this.extendedProperties = additionalProperties;
    }

    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.additionalProperties);
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Override
    public String toString() {
        return "PersonalProfile{fullName='" + this.fullName + '\'' + ", jobTitle='" + this.jobTitle + '\'' + ", associatedUserIds=" + this.associatedUserIds + ", extendedProperties=" + this.extendedProperties + ", additionalProperties=" + this.additionalProperties + ", contactDetails=" + this.getContactDetails() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", classifications=" + this.getClassifications() + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + ", originId='" + this.getOriginId() + '\'' + ", originName='" + this.getOriginName() + '\'' + ", originType='" + this.getOriginType() + '\'' + ", originLicense='" + this.getOriginLicense() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        PersonalProfile that = (PersonalProfile)objectToCompare;
        return Objects.equals(this.getAssociatedUserIds(), that.getAssociatedUserIds()) && Objects.equals(this.getExtendedProperties(), that.getExtendedProperties()) && Objects.equals(this.getAdditionalProperties(), that.getAdditionalProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAssociatedUserIds(), this.getExtendedProperties(), this.getAdditionalProperties());
    }
}

