/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommunityMembershipType;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalRole;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CommunityMember
extends PersonalRole {
    private static final long serialVersionUID = 1L;
    private CommunityMembershipType membershipType = null;
    private String communityGUID = null;

    public CommunityMember() {
    }

    public CommunityMember(CommunityMember template) {
        super(template);
        if (template != null) {
            this.membershipType = template.getMembershipType();
            this.communityGUID = template.getCommunityGUID();
        }
    }

    public CommunityMembershipType getMembershipType() {
        return this.membershipType;
    }

    public void setMembershipType(CommunityMembershipType membershipType) {
        this.membershipType = membershipType;
    }

    public String getCommunityGUID() {
        return this.communityGUID;
    }

    public void setCommunityGUID(String communityGUID) {
        this.communityGUID = communityGUID;
    }

    @Override
    public String toString() {
        return "CommunityMember{membershipType=" + this.membershipType + ", communityGUID='" + this.communityGUID + '\'' + ", extendedProperties=" + this.getExtendedProperties() + ", additionalProperties=" + this.getAdditionalProperties() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", classifications=" + this.getClassifications() + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + ", originId='" + this.getOriginId() + '\'' + ", originName='" + this.getOriginName() + '\'' + ", originType='" + this.getOriginType() + '\'' + ", originLicense='" + this.getOriginLicense() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CommunityMember that = (CommunityMember)objectToCompare;
        return this.getMembershipType() == that.getMembershipType() && Objects.equals(this.getCommunityGUID(), that.getCommunityGUID());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMembershipType(), this.getCommunityGUID());
    }
}

