/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ActorHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Classification;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Collection;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CollectionMemberHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Community;
import org.odpi.openmetadata.accessservices.communityprofile.properties.NoteEntryHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.NoteLogHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalRole;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ToDo;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ActorHeader.class, name="ActorHeader"), @JsonSubTypes.Type(value=Collection.class, name="Collection"), @JsonSubTypes.Type(value=CollectionMemberHeader.class, name="CollectionMemberHeader"), @JsonSubTypes.Type(value=Community.class, name="Community"), @JsonSubTypes.Type(value=NoteLogHeader.class, name="NoteLogHeader"), @JsonSubTypes.Type(value=NoteEntryHeader.class, name="NoteEntryHeader"), @JsonSubTypes.Type(value=PersonalRole.class, name="PersonalRole"), @JsonSubTypes.Type(value=ToDo.class, name="ToDo")})
public abstract class ReferenceableHeader
extends CommonHeader {
    private static final long serialVersionUID = 1L;
    private List<Classification> classifications = null;
    private String qualifiedName = null;
    private String name = null;
    private String description = null;

    public ReferenceableHeader() {
    }

    public ReferenceableHeader(ReferenceableHeader template) {
        super(template);
        if (template != null) {
            this.classifications = template.getClassifications();
            this.qualifiedName = template.getQualifiedName();
            this.name = template.getName();
            this.description = template.getDescription();
        }
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Classification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return this.classifications;
    }

    public void setClassifications(List<Classification> classifications) {
        this.classifications = classifications;
    }

    @Override
    public String toString() {
        return "ReferenceableHeader{classifications=" + this.classifications + ", qualifiedName='" + this.qualifiedName + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ReferenceableHeader that = (ReferenceableHeader)objectToCompare;
        return Objects.equals(this.getClassifications(), that.getClassifications()) && Objects.equals(this.getQualifiedName(), that.getQualifiedName()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getClassifications(), this.getQualifiedName(), this.getName(), this.getDescription());
    }
}

