/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.ffdc;

import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CommunityProfileErrorCode {
    NO_OTHER_IDENTITY(400, "OMAS-COMMUNITY-PROFILE-400-001 ", "The user identity {0} is the only identity assigned to profile {1} and therefore it can not be deleted", "No action was taken.", "If this user identity needs to be deleted, either make sure another identity has been added to the profile, or delete the profile first."),
    QUALIFIED_NAME_NOT_UNIQUE(400, "OMAS-COMMUNITY-PROFILE-400-002 ", "The qualified name passed in the parameter {1} of the {2} operation is not unique.", "The system is unable to create the requested object because the qualified name is not unique.", "Correct the qualified name passed on the call so it is a unique value."),
    UNKNOWN_IDENTITY(404, "OMAS-COMMUNITY-PROFILE-404-001 ", "The user identity {0} is not known", "No action was taken.", "Check that the user identity value is correct.  If it is correct then add it to the repository. Try the request again with a valid value."),
    OMRS_NOT_INITIALIZED(500, "OMAS-COMMUNITY-PROFILE-500-001 ", "The open metadata repository services are not initialized for the {0} operation", "The system is unable to connect to the open metadata property server.", "Check that the server where the Community Profile OMAS is running has initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    UNABLE_TO_CREATE_USER_IDENTITY(500, "OMAS-COMMUNITY-PROFILE-500-002 ", "Unable to create new user identity object for user id {0}", "The system returned a null from the addEntity request.", "Verify that the OMAS server running and their are no errors on the server side."),
    UNABLE_TO_CREATE_CONTRIBUTION_RECORD(500, "OMAS-COMMUNITY-PROFILE-500-003 ", "Method {0} for server {1} is unable to create new contribution record for profile with identifier of {2} supporting person with qualified name of {3}", "The system returned a null from the addEntity request.", "Verify that the OMAS server running and their are no errors on the server side."),
    NO_IDENTITY_FOR_PROFILE(500, "OMAS-COMMUNITY-PROFILE-500-004 ", "Profile {0} does not have an associated user identity", "The system returned a PropertyServerException rather than executing the request.  The profile is not usable without a user identity.", "Use the Community Profile OMAS API to either delete this profile or add a user identity to it."),
    PARSE_EVENT_ERROR(500, "OMAS-COMMUNITY-PROFILE-500-005 ", "Unable to publish the {0} event due to exception {1}.  The error message from the exception was {2}, the event contents was {3}", "The system detected an exception whilst parsing an event into a JSON String prior to publishing it.", "Investigate and correct the source of the error.  Once fixed, events will be published.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private CommunityProfileErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        log.debug(String.format("<== CommunityProfileErrorCode.getMessage(%s)", Arrays.toString(params)));
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("==> CommunityProfileErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String toString() {
        return "CommunityProfileErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + '}';
    }

    static {
        log = LoggerFactory.getLogger(CommunityProfileErrorCode.class);
    }
}

