/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CollectionMemberHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.OwnerType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetCollectionMember
extends CollectionMemberHeader {
    private static final long serialVersionUID = 1L;
    private String owner = null;
    private OwnerType ownerType = null;
    private List<String> zoneMembership = null;
    private String lastChange = null;
    private Date dateAssetCreated = null;
    private Date dateAssetLastUpdated = null;
    private Map<String, Object> extendedProperties = null;
    private Map<String, String> additionalProperties = null;

    public AssetCollectionMember() {
    }

    public AssetCollectionMember(AssetCollectionMember template) {
        super(template);
        if (template != null) {
            this.owner = template.getOwner();
            this.ownerType = template.getOwnerType();
            this.zoneMembership = template.getZoneMembership();
            this.lastChange = template.getLastChange();
            this.dateAssetCreated = template.getDateAssetCreated();
            this.dateAssetLastUpdated = template.getDateAssetLastUpdated();
            this.extendedProperties = template.getExtendedProperties();
            this.additionalProperties = template.getAdditionalProperties();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public OwnerType getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(OwnerType ownerType) {
        this.ownerType = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return this.zoneMembership;
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public String getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(String lastChange) {
        this.lastChange = lastChange;
    }

    public Date getDateAssetCreated() {
        if (this.dateAssetCreated == null) {
            return null;
        }
        return new Date(this.dateAssetCreated.getTime());
    }

    public void setDateAssetCreated(Date dateAssetCreated) {
        this.dateAssetCreated = dateAssetCreated;
    }

    public Date getDateAssetLastUpdated() {
        if (this.dateAssetLastUpdated == null) {
            return null;
        }
        return new Date(this.dateAssetLastUpdated.getTime());
    }

    public void setDateAssetLastUpdated(Date dateAssetLastUpdated) {
        this.dateAssetLastUpdated = dateAssetLastUpdated;
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.extendedProperties == null) {
            return null;
        }
        if (this.extendedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.extendedProperties);
    }

    public void setExtendedProperties(Map<String, Object> additionalProperties) {
        this.extendedProperties = additionalProperties;
    }

    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.additionalProperties);
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Override
    public String toString() {
        return "AssetCollectionMember{owner='" + this.owner + '\'' + ", ownerType='" + this.ownerType + '\'' + ", zoneMembership=" + this.zoneMembership + ", lastChange='" + this.lastChange + '\'' + ", dateAssetCreated=" + this.dateAssetCreated + ", dateAssetLastUpdated=" + this.dateAssetLastUpdated + ", extendedProperties=" + this.extendedProperties + ", additionalProperties=" + this.additionalProperties + ", dateAddedToCollection=" + this.getDateAddedToCollection() + ", membershipRationale='" + this.getMembershipRationale() + '\'' + ", watchStatus=" + this.getWatchStatus() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", classifications=" + this.getClassifications() + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetCollectionMember that = (AssetCollectionMember)objectToCompare;
        return Objects.equals(this.getOwner(), that.getOwner()) && Objects.equals(this.getOwnerType(), that.getOwnerType()) && Objects.equals(this.getZoneMembership(), that.getZoneMembership()) && Objects.equals(this.getLastChange(), that.getLastChange()) && Objects.equals(this.getDateAssetCreated(), that.getDateAssetCreated()) && Objects.equals(this.getDateAssetLastUpdated(), that.getDateAssetLastUpdated()) && Objects.equals(this.getExtendedProperties(), that.getExtendedProperties()) && Objects.equals(this.getAdditionalProperties(), that.getAdditionalProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOwner(), this.getOwnerType(), this.getZoneMembership(), this.getLastChange(), this.getDateAssetCreated(), this.getDateAssetLastUpdated(), this.getExtendedProperties(), this.getAdditionalProperties());
    }
}

