/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalRoleProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamMemberProperties
extends PersonalRoleProperties {
    private static final long serialVersionUID = 1L;
    private String membershipPosition = null;
    private String teamGUID = null;

    public TeamMemberProperties() {
    }

    public TeamMemberProperties(TeamMemberProperties template) {
        super(template);
        if (template != null) {
            this.membershipPosition = template.getMembershipPosition();
            this.teamGUID = template.getTeamGUID();
        }
    }

    public String getMembershipPosition() {
        return this.membershipPosition;
    }

    public void setMembershipPosition(String membershipPosition) {
        this.membershipPosition = membershipPosition;
    }

    public String getTeamGUID() {
        return this.teamGUID;
    }

    public void setTeamGUID(String teamGUID) {
        this.teamGUID = teamGUID;
    }

    @Override
    public String toString() {
        return "TeamMemberProperties{membershipPosition='" + this.membershipPosition + '\'' + ", teamGUID='" + this.teamGUID + '\'' + ", domainIdentifier=" + this.getDomainIdentifier() + ", roleId='" + this.getRoleId() + '\'' + ", scope='" + this.getScope() + '\'' + ", title='" + this.getTitle() + '\'' + ", description='" + this.getDescription() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TeamMemberProperties that = (TeamMemberProperties)objectToCompare;
        return Objects.equals(this.getMembershipPosition(), that.getMembershipPosition());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMembershipPosition());
    }
}

