/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.topics;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEventType;
import org.odpi.openmetadata.accessservices.communityprofile.events.FavouriteCollectionOutboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.events.KarmaPointOutboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.events.PersonalProfileOutboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.events.UserIdentityOutboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserIdentity;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommunityProfileOutTopicPublisher {
    private OpenMetadataTopicConnector openMetadataTopicConnector;
    private InvalidParameterHandler invalidParameterHandler;
    private ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(CommunityProfileOutTopicPublisher.class);

    public CommunityProfileOutTopicPublisher(OpenMetadataTopicConnector connector, InvalidParameterHandler invalidParameterHandler) {
        this.openMetadataTopicConnector = connector;
        this.invalidParameterHandler = invalidParameterHandler;
    }

    private void sendEvent(CommunityProfileOutboundEvent event) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "event";
        String methodName = "sendEvent";
        this.invalidParameterHandler.validateObject((Object)event, "event", "sendEvent");
        try {
            log.debug("Sending Event: " + event.getEventType().getEventTypeName());
            this.openMetadataTopicConnector.sendEvent(this.objectMapper.writeValueAsString((Object)event));
            log.debug("Event sent: " + event.getEventType().getEventTypeName());
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Throwable error) {
            String eventType = "<null>";
            if (event.getEventType() != null) {
                eventType = event.getEventType().getEventTypeName();
            }
            throw new InvalidParameterException(CommunityProfileErrorCode.PARSE_EVENT_ERROR.getMessageDefinition(eventType, error.getClass().getName(), error.getMessage(), event.toString()), this.getClass().getName(), "sendEvent", error, "event");
        }
    }

    public void sendNewUserIdentityEvent(UserIdentity bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewUserIdentityEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewUserIdentityEvent");
        UserIdentityOutboundEvent event = new UserIdentityOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.NEW_USER_IDENTITY_EVENT);
        event.setUserIdentity(bean);
        this.sendEvent(event);
    }

    public void sendNewExternalUserIdentityEvent(UserIdentity bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewExternalUserIdentityEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewExternalUserIdentityEvent");
        UserIdentityOutboundEvent event = new UserIdentityOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.NEW_REF_USER_IDENTITY_EVENT);
        event.setUserIdentity(bean);
        this.sendEvent(event);
    }

    public void sendUpdatedUserIdentityEvent(UserIdentity bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendUpdatedUserIdentityEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendUpdatedUserIdentityEvent");
        UserIdentityOutboundEvent event = new UserIdentityOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.UPDATED_USER_IDENTITY_EVENT);
        event.setUserIdentity(bean);
        this.sendEvent(event);
    }

    public void sendDeletedUserIdentityEvent(UserIdentity bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendDeletedUserIdentityEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendDeletedUserIdentityEvent");
        UserIdentityOutboundEvent event = new UserIdentityOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.DELETED_USER_IDENTITY_EVENT);
        event.setUserIdentity(bean);
        this.sendEvent(event);
    }

    public void sendNewPersonalProfileEvent(PersonalProfile bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewPersonalProfileEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewPersonalProfileEvent");
        PersonalProfileOutboundEvent event = new PersonalProfileOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.NEW_PERSONAL_PROFILE_EVENT);
        event.setPersonalProfile(bean);
        this.sendEvent(event);
    }

    public void sendNewExternalPersonalProfileEvent(PersonalProfile bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewExternalPersonalProfileEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewExternalPersonalProfileEvent");
        PersonalProfileOutboundEvent event = new PersonalProfileOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.NEW_REF_PERSONAL_PROFILE_EVENT);
        event.setPersonalProfile(bean);
        this.sendEvent(event);
    }

    public void sendUpdatedPersonalProfileEvent(PersonalProfile bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendUpdatedPersonalProfileEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendUpdatedPersonalProfileEvent");
        PersonalProfileOutboundEvent event = new PersonalProfileOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.UPDATED_PERSONAL_PROFILE_EVENT);
        event.setPersonalProfile(bean);
        this.sendEvent(event);
    }

    public void sendDeletedPersonalProfileEvent(PersonalProfile bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendDeletedPersonalProfileEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendDeletedPersonalProfileEvent");
        PersonalProfileOutboundEvent event = new PersonalProfileOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.DELETED_PERSONAL_PROFILE_EVENT);
        event.setPersonalProfile(bean);
        this.sendEvent(event);
    }

    public void sendKarmaPointPlateauEvent(PersonalProfile bean, String userId, int plateau, int totalPoints) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendKarmaPointPlateauEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendKarmaPointPlateauEvent");
        KarmaPointOutboundEvent event = new KarmaPointOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.KARMA_POINT_PLATEAU_EVENT);
        event.setPersonalProfile(bean);
        event.setUserId(userId);
        event.setPlateau(plateau);
        event.setPointsTotal(totalPoints);
        this.sendEvent(event);
    }

    public void sendNewAssetInCollectionEvent(PersonalProfile bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewAssetInCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewAssetInCollectionEvent");
        FavouriteCollectionOutboundEvent event = new FavouriteCollectionOutboundEvent(CommunityProfileOutboundEventType.NEW_ASSET_IN_COLLECTION_EVENT, bean, userId, memberGUID, memberTypeName);
        this.sendEvent(event);
    }

    public void sendAssetRemovedFromCollectionEvent(PersonalProfile bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendAssetRemovedFromCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendAssetRemovedFromCollectionEvent");
        FavouriteCollectionOutboundEvent event = new FavouriteCollectionOutboundEvent(CommunityProfileOutboundEventType.ASSET_REMOVED_FROM_COLLECTION_EVENT, bean, userId, memberGUID, memberTypeName);
        this.sendEvent(event);
    }

    public void sendNewProjectInCollectionEvent(PersonalProfile bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewProjectInCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewProjectInCollectionEvent");
        FavouriteCollectionOutboundEvent event = new FavouriteCollectionOutboundEvent(CommunityProfileOutboundEventType.NEW_PROJECT_IN_COLLECTION_EVENT, bean, userId, memberGUID, memberTypeName);
        this.sendEvent(event);
    }

    public void sendProjectRemovedFromCollectionEvent(PersonalProfile bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendProjectRemovedFromCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendProjectRemovedFromCollectionEvent");
        FavouriteCollectionOutboundEvent event = new FavouriteCollectionOutboundEvent(CommunityProfileOutboundEventType.PROJECT_REMOVED_FROM_COLLECTION_EVENT, bean, userId, memberGUID, memberTypeName);
        this.sendEvent(event);
    }

    public void sendNewCommunityInCollectionEvent(PersonalProfile bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewCommunityInCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewCommunityInCollectionEvent");
        FavouriteCollectionOutboundEvent event = new FavouriteCollectionOutboundEvent(CommunityProfileOutboundEventType.NEW_COMMUNITY_IN_COLLECTION_EVENT, bean, userId, memberGUID, memberTypeName);
        this.sendEvent(event);
    }

    public void sendCommunityRemovedFromCollectionEvent(PersonalProfile bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendCommunityRemovedFromCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendCommunityRemovedFromCollectionEvent");
        FavouriteCollectionOutboundEvent event = new FavouriteCollectionOutboundEvent(CommunityProfileOutboundEventType.COMMUNITY_REMOVED_FROM_COLLECTION_EVENT, bean, userId, memberGUID, memberTypeName);
        this.sendEvent(event);
    }
}

