/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.events.PersonalProfileOutboundEvent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class KarmaPointOutboundEvent
extends PersonalProfileOutboundEvent {
    private static final long serialVersionUID = 1L;
    private String userId = null;
    private long pointsTotal = 0L;
    private long plateau = 0L;

    public KarmaPointOutboundEvent() {
    }

    public KarmaPointOutboundEvent(KarmaPointOutboundEvent template) {
        super(template);
        if (template != null) {
            this.userId = template.getUserId();
            this.pointsTotal = template.getPointsTotal();
            this.plateau = template.getPlateau();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public long getPointsTotal() {
        return this.pointsTotal;
    }

    public void setPointsTotal(long pointsTotal) {
        this.pointsTotal = pointsTotal;
    }

    public long getPlateau() {
        return this.plateau;
    }

    public void setPlateau(long plateau) {
        this.plateau = plateau;
    }

    @Override
    public String toString() {
        return "KarmaPointOutboundEvent{userId='" + this.userId + '\'' + ", pointsTotal=" + this.pointsTotal + ", plateau=" + this.plateau + ", personalProfile=" + this.getPersonalProfile() + ", eventType=" + this.getEventType() + ", eventVersionId=" + this.getEventVersionId() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        KarmaPointOutboundEvent that = (KarmaPointOutboundEvent)objectToCompare;
        return this.getPointsTotal() == that.getPointsTotal() && this.getPlateau() == that.getPlateau() && Objects.equals(this.getUserId(), that.getUserId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getUserId(), this.getPointsTotal(), this.getPlateau());
    }
}

