/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserFeedbackHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Tag
extends UserFeedbackHeader {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String description = null;
    private boolean isPrivate = false;

    public Tag() {
    }

    public Tag(Tag template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.description = template.getDescription();
            this.isPrivate = template.getIsPrivate();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getIsPrivate() {
        return this.isPrivate;
    }

    public void setIsPrivate(boolean privateTag) {
        this.isPrivate = privateTag;
    }

    @Override
    public String toString() {
        return "Tag{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", isPublic=" + this.isPrivate + ", userId='" + this.getUserId() + '\'' + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Tag tag = (Tag)objectToCompare;
        return this.getIsPrivate() == tag.getIsPrivate() && Objects.equals(this.getName(), tag.getName()) && Objects.equals(this.getDescription(), tag.getDescription());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getDescription(), this.getIsPrivate());
    }
}

