/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CollectionMemberHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectCollectionMember
extends CollectionMemberHeader {
    private static final long serialVersionUID = 1L;
    private String status = null;
    private Date startDate = null;
    private Date plannedEndDate = null;
    private Map<String, Object> extendedProperties = null;
    private Map<String, String> additionalProperties = null;

    public ProjectCollectionMember() {
    }

    public ProjectCollectionMember(ProjectCollectionMember template) {
        super(template);
        if (template != null) {
            this.status = template.getStatus();
            this.startDate = template.getStartDate();
            this.plannedEndDate = template.getPlannedEndDate();
            this.extendedProperties = template.getExtendedProperties();
            this.additionalProperties = template.getAdditionalProperties();
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getStartDate() {
        if (this.startDate == null) {
            return null;
        }
        return new Date(this.startDate.getTime());
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getPlannedEndDate() {
        if (this.plannedEndDate == null) {
            return null;
        }
        return new Date(this.plannedEndDate.getTime());
    }

    public void setPlannedEndDate(Date plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.extendedProperties == null) {
            return null;
        }
        if (this.extendedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.extendedProperties);
    }

    public void setExtendedProperties(Map<String, Object> additionalProperties) {
        this.extendedProperties = additionalProperties;
    }

    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.additionalProperties);
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Override
    public String toString() {
        return "ProjectCollectionMember{status='" + this.status + '\'' + ", startDate=" + this.startDate + ", plannedEndDate=" + this.plannedEndDate + ", dateAddedToCollection=" + this.getDateAddedToCollection() + ", membershipRationale='" + this.getMembershipRationale() + '\'' + ", watchStatus=" + this.getWatchStatus() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", classifications=" + this.getClassifications() + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ProjectCollectionMember that = (ProjectCollectionMember)objectToCompare;
        return Objects.equals(this.getStatus(), that.getStatus()) && Objects.equals(this.getStartDate(), that.getStartDate()) && Objects.equals(this.getPlannedEndDate(), that.getPlannedEndDate());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatus(), this.getStartDate(), this.getPlannedEndDate());
    }
}

