/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ActorHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Team;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Team.class, name="Team")})
public class TeamSummary
extends ActorHeader {
    private static final long serialVersionUID = 1L;
    private String teamType = null;
    private String superTeam = null;
    private List<String> subTeams = null;

    public TeamSummary() {
    }

    public TeamSummary(TeamSummary template) {
        super(template);
        if (template != null) {
            this.teamType = template.getTeamType();
            this.superTeam = template.getSuperTeam();
            this.subTeams = template.getSubTeams();
        }
    }

    public String getTeamType() {
        return this.teamType;
    }

    public void setTeamType(String teamType) {
        this.teamType = teamType;
    }

    public String getSuperTeam() {
        return this.superTeam;
    }

    public void setSuperTeam(String superTeam) {
        this.superTeam = superTeam;
    }

    public List<String> getSubTeams() {
        if (this.subTeams == null) {
            return null;
        }
        if (this.subTeams.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.subTeams);
    }

    public void setSubTeams(List<String> subTeams) {
        this.subTeams = subTeams;
    }

    @Override
    public String toString() {
        return "TeamSummary{teamType='" + this.teamType + '\'' + ", superTeam='" + this.superTeam + '\'' + ", subTeams=" + this.subTeams + ", contactDetails=" + this.getContactDetails() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", classifications=" + this.getClassifications() + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TeamSummary that = (TeamSummary)objectToCompare;
        return Objects.equals(this.getTeamType(), that.getTeamType()) && Objects.equals(this.getSuperTeam(), that.getSuperTeam()) && Objects.equals(this.getSubTeams(), that.getSubTeams());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTeamType(), this.getSuperTeam(), this.getSubTeams());
    }
}

