/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.topics;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileInboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileInboundEventType;
import org.odpi.openmetadata.accessservices.communityprofile.topics.CommunityProfileOutTopicPublisher;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityProfileInTopicListener {
    private static final Logger log = LoggerFactory.getLogger(CommunityProfileOutTopicPublisher.class);

    public void processInTopicEvent(CommunityProfileInboundEvent event) {
        log.debug("Processing instance event: " + event);
        if (event == null) {
            log.debug("Null community profile event - ignoring event");
        } else {
            CommunityProfileInboundEventType eventType = event.getEventType();
            if (eventType != null) {
                switch (eventType) {
                    default: 
                }
            } else {
                log.error("Ignored event - null type: " + event.toString());
            }
        }
    }

    class OpenMetadataInboundListener
    implements OpenMetadataTopicListener {
        private CommunityProfileInTopicListener communityProfileInTopicListener;
        private ObjectMapper objectMapper = new ObjectMapper();

        public OpenMetadataInboundListener(CommunityProfileInTopicListener communityProfileInTopicListener) {
            this.communityProfileInTopicListener = communityProfileInTopicListener;
        }

        public void processEvent(String eventPayload) {
            try {
                CommunityProfileInboundEvent communityProfileInboundEvent = (CommunityProfileInboundEvent)this.objectMapper.readValue(eventPayload, CommunityProfileInboundEvent.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

