/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContributionRecord
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private int karmaPoints = 0;
    private int karmaPointPlateau = 0;

    public ContributionRecord() {
    }

    public ContributionRecord(ContributionRecord template) {
        super(template);
        if (template != null) {
            this.karmaPoints = template.getKarmaPoints();
            this.karmaPointPlateau = template.getKarmaPointPlateau();
        }
    }

    public int getKarmaPoints() {
        return this.karmaPoints;
    }

    public void setKarmaPoints(int karmaPoints) {
        this.karmaPoints = karmaPoints;
    }

    public int getKarmaPointPlateau() {
        return this.karmaPointPlateau;
    }

    public void setKarmaPointPlateau(int karmaPointPlateau) {
        this.karmaPointPlateau = karmaPointPlateau;
    }

    @Override
    public String toString() {
        return "ContributionRecord{karmaPoints=" + this.karmaPoints + ", karmaPointPlateau=" + this.karmaPointPlateau + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ContributionRecord that = (ContributionRecord)objectToCompare;
        return this.getKarmaPoints() == that.getKarmaPoints() && this.getKarmaPointPlateau() == that.getKarmaPointPlateau();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getKarmaPoints(), this.getKarmaPointPlateau());
    }
}

