/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CollectionOrder implements Serializable
{
    NAME(0, 0, "Name", "Order the collection by the names of the members in the collection."),
    OWNER(1, 1, "Owner", "Order the collection by the owners of the members in the collection (assets only)."),
    DATE_ADDED(2, 2, "Date Added", "Order the collection by the date that the members were added to the collection."),
    DATE_UPDATED(3, 3, "Date Updated", "Order the collection by the date that the members were updated in the collection."),
    DATE_CREATED(4, 4, "Date Created", "Order the collection by the date that the members were created in the collection."),
    OTHER(99, 99, "Other", "Order the collection by another value.");

    private static final long serialVersionUID = 1L;
    public static final String ENUM_TYPE_GUID = "1d412439-4272-4a7e-a940-1065f889fc56";
    public static final String ENUM_TYPE_NAME = "OrderBy";
    private final int openTypeOrdinal;
    private final int ordinal;
    private final String name;
    private final String description;

    private CollectionOrder(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "CollectionOrder : " + this.name;
    }
}

