/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.AssetCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.CommunityCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ProjectCollectionMember;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AssetCollectionMember.class, name="AssetCollectionMember"), @JsonSubTypes.Type(value=ProjectCollectionMember.class, name="ProjectCollectionMember"), @JsonSubTypes.Type(value=CommunityCollectionMember.class, name="CommunityCollectionMember")})
public abstract class CollectionMemberHeader
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private ElementHeader elementHeader = null;
    private Date dateAddedToCollection = null;
    private String membershipRationale = null;

    public CollectionMemberHeader() {
    }

    public CollectionMemberHeader(CollectionMemberHeader template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.dateAddedToCollection = template.getDateAddedToCollection();
            this.membershipRationale = template.getMembershipRationale();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public Date getDateAddedToCollection() {
        if (this.dateAddedToCollection == null) {
            return null;
        }
        return new Date(this.dateAddedToCollection.getTime());
    }

    public void setDateAddedToCollection(Date dateAddedToCollection) {
        this.dateAddedToCollection = dateAddedToCollection;
    }

    public String getMembershipRationale() {
        return this.membershipRationale;
    }

    public void setMembershipRationale(String membershipRationale) {
        this.membershipRationale = membershipRationale;
    }

    public String toString() {
        return "CollectionMemberHeader{elementHeader=" + this.elementHeader + ", dateAddedToCollection=" + this.dateAddedToCollection + ", membershipRationale='" + this.membershipRationale + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        CollectionMemberHeader that = (CollectionMemberHeader)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.dateAddedToCollection, that.dateAddedToCollection) && Objects.equals(this.membershipRationale, that.membershipRationale);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getElementHeader(), this.getDateAddedToCollection(), this.getMembershipRationale());
    }
}

