/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileEventHeader;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEventType;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ElementStub;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CommunityProfileOutboundEvent
extends CommunityProfileEventHeader {
    private static final long serialVersionUID = 1L;
    private CommunityProfileOutboundEventType eventType = null;
    private ElementStub principleElement = null;
    private String classificationName = null;
    private ElementStub endOneElement = null;
    private ElementStub endTwoElement = null;
    private String userId = null;
    private boolean isPublic = false;
    private long pointsTotal = 0L;
    private long plateau = 0L;

    public CommunityProfileOutboundEvent() {
    }

    public CommunityProfileOutboundEvent(CommunityProfileOutboundEvent template) {
        super(template);
        if (template != null) {
            this.eventType = template.getEventType();
            this.principleElement = template.getPrincipleElement();
            this.classificationName = template.getClassificationName();
            this.endOneElement = template.getEndOneElement();
            this.endTwoElement = template.getEndTwoElement();
            this.userId = template.getUserId();
            this.pointsTotal = template.getPointsTotal();
            this.plateau = template.getPlateau();
        }
    }

    public CommunityProfileOutboundEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(CommunityProfileOutboundEventType eventType) {
        this.eventType = eventType;
    }

    public ElementStub getPrincipleElement() {
        return this.principleElement;
    }

    public void setPrincipleElement(ElementStub principleElement) {
        this.principleElement = principleElement;
    }

    public String getClassificationName() {
        return this.classificationName;
    }

    public void setClassificationName(String classificationName) {
        this.classificationName = classificationName;
    }

    public ElementStub getEndOneElement() {
        return this.endOneElement;
    }

    public void setEndOneElement(ElementStub endOneElement) {
        this.endOneElement = endOneElement;
    }

    public ElementStub getEndTwoElement() {
        return this.endTwoElement;
    }

    public void setEndTwoElement(ElementStub endTwoElement) {
        this.endTwoElement = endTwoElement;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public long getPointsTotal() {
        return this.pointsTotal;
    }

    public void setPointsTotal(long pointsTotal) {
        this.pointsTotal = pointsTotal;
    }

    public long getPlateau() {
        return this.plateau;
    }

    public void setPlateau(long plateau) {
        this.plateau = plateau;
    }

    @Override
    public String toString() {
        return "CommunityProfileOutboundEvent{eventType=" + this.eventType + ", principleElement=" + this.principleElement + ", classificationName='" + this.classificationName + "', endOneElement=" + this.endOneElement + ", endTwoElement=" + this.endTwoElement + ", userId='" + this.userId + "', isPublic=" + this.isPublic + ", pointsTotal=" + this.pointsTotal + ", plateau=" + this.plateau + ", eventVersionId=" + this.getEventVersionId() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CommunityProfileOutboundEvent event = (CommunityProfileOutboundEvent)objectToCompare;
        return this.isPublic == event.isPublic && this.pointsTotal == event.pointsTotal && this.plateau == event.plateau && this.eventType == event.eventType && Objects.equals(this.principleElement, event.principleElement) && Objects.equals(this.classificationName, event.classificationName) && Objects.equals(this.endOneElement, event.endOneElement) && Objects.equals(this.endTwoElement, event.endTwoElement) && Objects.equals(this.userId, event.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.eventType, this.principleElement, this.classificationName, this.endOneElement, this.endTwoElement, this.userId, this.isPublic, this.pointsTotal, this.plateau);
    }
}

