/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.AssetCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.rest.CommunityProfileOMASAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetListResponse
extends CommunityProfileOMASAPIResponse {
    private static final long serialVersionUID = 1L;
    private List<AssetCollectionMember> assets = null;
    private int startingFromElement = 0;
    private int totalListSize = 0;

    public AssetListResponse() {
    }

    public AssetListResponse(AssetListResponse template) {
        super(template);
        if (template != null) {
            this.startingFromElement = template.getStartingFromElement();
            this.totalListSize = template.getTotalListSize();
            this.assets = template.getAssets();
        }
    }

    public List<AssetCollectionMember> getAssets() {
        if (this.assets == null) {
            return null;
        }
        if (this.assets.isEmpty()) {
            return null;
        }
        return this.assets;
    }

    public void setAssets(List<AssetCollectionMember> assets) {
        this.assets = assets;
    }

    public int getStartingFromElement() {
        return this.startingFromElement;
    }

    public void setStartingFromElement(int startingFromElement) {
        this.startingFromElement = startingFromElement;
    }

    public int getTotalListSize() {
        return this.totalListSize;
    }

    public void setTotalListSize(int totalListSize) {
        this.totalListSize = totalListSize;
    }

    @Override
    public String toString() {
        return "AssetListResponse{assets=" + this.assets + ", startingFromElement=" + this.startingFromElement + ", totalListSize=" + this.totalListSize + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetListResponse that = (AssetListResponse)((Object)objectToCompare);
        return this.getStartingFromElement() == that.getStartingFromElement() && this.getTotalListSize() == that.getTotalListSize() && Objects.equals(this.getAssets(), that.getAssets());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAssets(), this.getStartingFromElement(), this.getTotalListSize());
    }
}

