/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String identifier = null;
    private String name = null;
    private String description = null;
    private String status = null;
    private Date startDate = null;
    private Date plannedEndDate = null;

    public ProjectProperties() {
    }

    public ProjectProperties(ProjectProperties template) {
        super(template);
        if (template != null) {
            this.identifier = template.getIdentifier();
            this.name = template.getName();
            this.description = template.getDescription();
            this.status = template.getStatus();
            this.startDate = template.getStartDate();
            this.plannedEndDate = template.getPlannedEndDate();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getStartDate() {
        if (this.startDate == null) {
            return null;
        }
        return new Date(this.startDate.getTime());
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getPlannedEndDate() {
        if (this.plannedEndDate == null) {
            return null;
        }
        return new Date(this.plannedEndDate.getTime());
    }

    public void setPlannedEndDate(Date plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    @Override
    public String toString() {
        return "ProjectProperties{identifier='" + this.identifier + "', name='" + this.name + "', description='" + this.description + "', status='" + this.status + "', startDate=" + this.startDate + ", plannedEndDate=" + this.plannedEndDate + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ProjectProperties that = (ProjectProperties)objectToCompare;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.status, that.status) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.plannedEndDate, that.plannedEndDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.identifier, this.name, this.description, this.status, this.startDate, this.plannedEndDate);
    }
}

