/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContributionRecord
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private long karmaPoints = 0L;
    private long karmaPointPlateau = 0L;
    private boolean isPublic = false;

    public ContributionRecord() {
    }

    public ContributionRecord(ContributionRecord template) {
        super(template);
        if (template != null) {
            this.karmaPoints = template.getKarmaPoints();
            this.karmaPointPlateau = template.getKarmaPointPlateau();
            this.isPublic = template.getIsPublic();
        }
    }

    public long getKarmaPoints() {
        return this.karmaPoints;
    }

    public void setKarmaPoints(long karmaPoints) {
        this.karmaPoints = karmaPoints;
    }

    public long getKarmaPointPlateau() {
        return this.karmaPointPlateau;
    }

    public void setKarmaPointPlateau(long karmaPointPlateau) {
        this.karmaPointPlateau = karmaPointPlateau;
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public String toString() {
        return "ContributionRecord{karmaPoints=" + this.karmaPoints + ", karmaPointPlateau=" + this.karmaPointPlateau + ", isPublic=" + this.isPublic + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ContributionRecord that = (ContributionRecord)objectToCompare;
        return this.karmaPoints == that.karmaPoints && this.karmaPointPlateau == that.karmaPointPlateau && this.isPublic == that.isPublic;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.karmaPoints, this.karmaPointPlateau, this.isPublic);
    }
}

